package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询分片副本状态。 */
public class Dcs2QueryFragmentReplicationStateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2QueryFragmentReplicationStateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/instanceManageMgrServant/queryFragmentReplicationState",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryFragmentReplicationStateResponse send(
            Credential credential, QueryFragmentReplicationStateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.fragmentName != null) {
            ctReq.addParam("fragmentName", request.fragmentName);
            request.fragmentName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryFragmentReplicationStateResponse.class);
    }

    public static class QueryFragmentReplicationStateRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 分片名称<br>
         * <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7740&isNormal=1&vid=270">查询集群节点信息</a>
         * RedisNode表fragmentName字段
         */
        @JsonProperty("fragmentName")
        private String fragmentName;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getFragmentName() {
            return this.fragmentName;
        }

        public void setFragmentName(String fragmentName) {
            this.fragmentName = fragmentName;
        }
    }

    public static class QueryFragmentReplicationStateResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private List<QueryFragmentReplicationStateReturnObjResponse> returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<QueryFragmentReplicationStateReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<QueryFragmentReplicationStateReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryFragmentReplicationStateReturnObjResponse {
        /**
         * 角色。
         * <li>master：主节点。
         * <li>slave： 从节点。
         */
        @JsonProperty("role")
        private String role;

        /** vpc IP。 */
        @JsonProperty("vpcIp")
        private String vpcIp;

        /**
         * 节点状态。
         * <li>CACHE.COMM.STATUS：正常。
         * <li>CACHE.DIAT.PREP：扩容数据准备。
         * <li>CACHE.DIAT.PROCESS：执行扩容数据。
         * <li>CACHE.DIAT.DEL：删除。
         * <li>CACHE.PROB.SWIT：故障待切换。
         */
        @JsonProperty("status")
        private String status;

        /** 可用区名称。 */
        @JsonProperty("azName")
        private String azName;

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getVpcIp() {
            return this.vpcIp;
        }

        public void setVpcIp(String vpcIp) {
            this.vpcIp = vpcIp;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }
    }
}
