package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Map;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询分布式缓存Redis诊断分析报告详情，内容包含实例可用性、数据同步、负载状态、存储、网络、慢请求、命令耗时统计等信息。 */
public class Dcs2QueryAnalysisInstanceTasksInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2QueryAnalysisInstanceTasksInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/keyAnalysisMgrServant/queryAnalysisInstanceTasksInfo",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public QueryAnalysisInstanceTasksInfoResponse send(
            Credential credential, QueryAnalysisInstanceTasksInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.taskId != null) {
            ctReq.addParam("taskId", request.taskId);
            request.taskId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(QueryAnalysisInstanceTasksInfoResponse.class);
    }

    public static class QueryAnalysisInstanceTasksInfoRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }

    public static class QueryAnalysisInstanceTasksInfoResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private QueryAnalysisInstanceTasksInfoReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public QueryAnalysisInstanceTasksInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(QueryAnalysisInstanceTasksInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class QueryAnalysisInstanceTasksInfoReturnObjResponse {
        /** Redis集群名。 */
        @JsonProperty("redisSetname")
        private String redisSetname;

        /**
         * 是否数据同步。
         * <li>True:同步。
         * <li>False:不同步。
         */
        @JsonProperty("redisSync")
        private Boolean redisSync;

        /** 节点诊断报告Map<nodeName,AnalysisInstanceOverallInfo> */
        @JsonProperty("map")
        private Map<String,QueryAnalysisInstanceTasksInfoReturnObjMapResponse> map;

        /**
         * 服务可用性。
         * <li>True：服务可用。
         * <li>False：服务不可用。
         */
        @JsonProperty("writeable")
        private Boolean writeable;

        public String getRedisSetname() {
            return this.redisSetname;
        }

        public void setRedisSetname(String redisSetname) {
            this.redisSetname = redisSetname;
        }

        public Boolean getRedisSync() {
            return this.redisSync;
        }

        public void setRedisSync(Boolean redisSync) {
            this.redisSync = redisSync;
        }

        public Map<String,QueryAnalysisInstanceTasksInfoReturnObjMapResponse> getMap() {
            return this.map;
        }

        public void setMap(Map<String,QueryAnalysisInstanceTasksInfoReturnObjMapResponse> map) {
            this.map = map;
        }

        public Boolean getWriteable() {
            return this.writeable;
        }

        public void setWriteable(Boolean writeable) {
            this.writeable = writeable;
        }
    }

    public static class QueryAnalysisInstanceTasksInfoReturnObjMapResponse {
        /**
         * 主从角色。
         * <li>Master：主。
         * <li>Slave：从。
         */
        @JsonProperty("role")
        private String role;

        /**
         * redis是否存活。
         * <li>True：存活。
         * <li>False：节点宕掉。
         */
        @JsonProperty("alive")
        private Boolean alive;

        /** 可用区名称。 */
        @JsonProperty("azName")
        private String azName;

        /**
         * Redis节点名称，可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7752&isNormal=1&vid=270">获取redis节点名列表</a>
         * 接口，使用node表nodeName字段。
         */
        @JsonProperty("redisNodename")
        private String redisNodename;

        /** 节点地址。 */
        @JsonProperty("redisUrl")
        private String redisUrl;

        /**
         * 连接数诊断结果是否正常。
         * <li>True：正常。
         * <li>False：不正常
         */
        @JsonProperty("clientflag")
        private Boolean clientflag;

        /** 慢日志。 */
        @JsonProperty("slowlogList")
        private List<QueryAnalysisInstanceTasksInfoReturnObjMapSlowlogListResponse> slowlogList;

        /**
         * 命令耗时诊断 ,"select":
         * "{\"usec_per_call\":\"1.25\",\"calls\":\"4\",\"usec\":\"5\"}"，usec_per_call：平均耗时（ms）；calls:执行次数；
         * usec：总耗时
         */
        @JsonProperty("commandMap")
        private Map<String, String> commandMap;

        /**
         * 内存使用量诊断结果是否正常。
         * <li>True：正常。
         * <li>False：不正常。
         */
        @JsonProperty("memoryflag")
        private Boolean memoryflag;

        /** 内存使用率%。 */
        @JsonProperty("usedMemoryRate")
        private Double usedMemoryRate;

        /**
         * 内部内存碎片率诊断结果是否正常。
         * <li>True：正常。
         * <li>False：不正常。
         */
        @JsonProperty("frageflag")
        private Boolean frageflag;

        /** 内存碎片率%。 */
        @JsonProperty("memFragmentationRate")
        private Double memFragmentationRate;

        /** 客户端连接数。 */
        @JsonProperty("clientConnectionnums")
        private Long clientConnectionnums;

        /**
         * cpu负载是否正常。
         * <li>True：正常。
         * <li>False：不正常
         */
        @JsonProperty("cpuflag")
        private Boolean cpuflag;

        /** CPU使用率%。 */
        @JsonProperty("cpuRate")
        private Double cpuRate;

        /**
         * 缓存命中率诊断结果是否正常。
         * <li>True：正常。
         * <li>False：不正常。
         */
        @JsonProperty("hitflag")
        private Boolean hitflag;

        /** 缓存命中率%。 */
        @JsonProperty("keyspaceHitsRate")
        private Double keyspaceHitsRate;

        /**
         * 持久化是否正常。
         * <li>True：正常。
         * <li>False：不正常。
         */
        @JsonProperty("perSistflag")
        private Boolean perSistflag;

        /** 异常数量。 */
        @JsonProperty("excepnum")
        private Long excepnum;

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public Boolean getAlive() {
            return this.alive;
        }

        public void setAlive(Boolean alive) {
            this.alive = alive;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }

        public String getRedisNodename() {
            return this.redisNodename;
        }

        public void setRedisNodename(String redisNodename) {
            this.redisNodename = redisNodename;
        }

        public String getRedisUrl() {
            return this.redisUrl;
        }

        public void setRedisUrl(String redisUrl) {
            this.redisUrl = redisUrl;
        }

        public Boolean getClientflag() {
            return this.clientflag;
        }

        public void setClientflag(Boolean clientflag) {
            this.clientflag = clientflag;
        }

        public List<QueryAnalysisInstanceTasksInfoReturnObjMapSlowlogListResponse>
                getSlowlogList() {
            return this.slowlogList;
        }

        public void setSlowlogList(
                List<QueryAnalysisInstanceTasksInfoReturnObjMapSlowlogListResponse> slowlogList) {
            this.slowlogList = slowlogList;
        }

        public Map<String,String> getCommandMap() {
            return this.commandMap;
        }

        public void setCommandMap(Map<String, String> commandMap) {
            this.commandMap = commandMap;
        }

        public Boolean getMemoryflag() {
            return this.memoryflag;
        }

        public void setMemoryflag(Boolean memoryflag) {
            this.memoryflag = memoryflag;
        }

        public Double getUsedMemoryRate() {
            return this.usedMemoryRate;
        }

        public void setUsedMemoryRate(Double usedMemoryRate) {
            this.usedMemoryRate = usedMemoryRate;
        }

        public Boolean getFrageflag() {
            return this.frageflag;
        }

        public void setFrageflag(Boolean frageflag) {
            this.frageflag = frageflag;
        }

        public Double getMemFragmentationRate() {
            return this.memFragmentationRate;
        }

        public void setMemFragmentationRate(Double memFragmentationRate) {
            this.memFragmentationRate = memFragmentationRate;
        }

        public Long getClientConnectionnums() {
            return this.clientConnectionnums;
        }

        public void setClientConnectionnums(Long clientConnectionnums) {
            this.clientConnectionnums = clientConnectionnums;
        }

        public Boolean getCpuflag() {
            return this.cpuflag;
        }

        public void setCpuflag(Boolean cpuflag) {
            this.cpuflag = cpuflag;
        }

        public Double getCpuRate() {
            return this.cpuRate;
        }

        public void setCpuRate(Double cpuRate) {
            this.cpuRate = cpuRate;
        }

        public Boolean getHitflag() {
            return this.hitflag;
        }

        public void setHitflag(Boolean hitflag) {
            this.hitflag = hitflag;
        }

        public Double getKeyspaceHitsRate() {
            return this.keyspaceHitsRate;
        }

        public void setKeyspaceHitsRate(Double keyspaceHitsRate) {
            this.keyspaceHitsRate = keyspaceHitsRate;
        }

        public Boolean getPerSistflag() {
            return this.perSistflag;
        }

        public void setPerSistflag(Boolean perSistflag) {
            this.perSistflag = perSistflag;
        }

        public Long getExcepnum() {
            return this.excepnum;
        }

        public void setExcepnum(Long excepnum) {
            this.excepnum = excepnum;
        }
    }

    public static class QueryAnalysisInstanceTasksInfoReturnObjMapSlowlogListResponse {
        /** 日志ID */
        @JsonProperty("id")
        private String id;

        /** 开始时间 */
        @JsonProperty("beginTime")
        private String beginTime;

        /** 消耗时间ms */
        @JsonProperty("cost")
        private String cost;

        /** 命令、参数 */
        @JsonProperty("command")
        private String command;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(String beginTime) {
            this.beginTime = beginTime;
        }

        public String getCost() {
            return this.cost;
        }

        public void setCost(String cost) {
            this.cost = cost;
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }
    }

}
