package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询租户所有标签列表。 */
public class Dcs2PageListLabelApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2PageListLabelApi(CtyunClient client) {
        this.client = client;
        this.template = new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v2/label/pageList", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public PageListLabelResponse send(Credential credential, PageListLabelRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageIndex != null) {
            ctReq.addParam("pageIndex", String.valueOf(request.pageIndex));
            request.pageIndex = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.labelKey != null) {
            ctReq.addParam("labelKey", request.labelKey);
            request.labelKey = null;
        }
        if (request.labelVal != null) {
            ctReq.addParam("labelVal", request.labelVal);
            request.labelVal = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(PageListLabelResponse.class);
    }

    public static class PageListLabelRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 当前页码（默认值：1）。 */
        @JsonProperty("pageIndex")
        private Integer pageIndex;

        /** 每页行数（默认值：10，范围：1-50）。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 标签键（精确匹配查询）。 */
        @JsonProperty("labelKey")
        private String labelKey;

        /** 标签值（精确匹配查询）。 */
        @JsonProperty("labelVal")
        private String labelVal;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageIndex() {
            return this.pageIndex;
        }

        public void setPageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getLabelKey() {
            return this.labelKey;
        }

        public void setLabelKey(String labelKey) {
            this.labelKey = labelKey;
        }

        public String getLabelVal() {
            return this.labelVal;
        }

        public void setLabelVal(String labelVal) {
            this.labelVal = labelVal;
        }
    }

    public static class PageListLabelResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private PageListLabelReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public PageListLabelReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(PageListLabelReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class PageListLabelReturnObjResponse {
        /** 标签键结束行号。 */
        @JsonProperty("endRow")
        private Integer endRow;

        /** 标签键列表。 */
        @JsonProperty("list")
        private List<PageListLabelReturnObjListResponse> list;

        /** 请求页码。 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页数量。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 总页数。 */
        @JsonProperty("pages")
        private Integer pages;

        /** 标签键开始行号。 */
        @JsonProperty("startRow")
        private Integer startRow;

        /** 标签键值对总数。 */
        @JsonProperty("total")
        private Integer total;

        public Integer getEndRow() {
            return this.endRow;
        }

        public void setEndRow(Integer endRow) {
            this.endRow = endRow;
        }

        public List<PageListLabelReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<PageListLabelReturnObjListResponse> list) {
            this.list = list;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getPages() {
            return this.pages;
        }

        public void setPages(Integer pages) {
            this.pages = pages;
        }

        public Integer getStartRow() {
            return this.startRow;
        }

        public void setStartRow(Integer startRow) {
            this.startRow = startRow;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }
    }

    public static class PageListLabelReturnObjListResponse {
        /** 标签键。 */
        @JsonProperty("key")
        private String key;

        /** 标签键值对象。 */
        @JsonProperty("data")
        private List<PageListLabelReturnObjListDataResponse> data;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public List<PageListLabelReturnObjListDataResponse> getData() {
            return this.data;
        }

        public void setData(List<PageListLabelReturnObjListDataResponse> data) {
            this.data = data;
        }
    }

    public static class PageListLabelReturnObjListDataResponse {
        /** 标签键。 */
        @JsonProperty("key")
        private String key;

        /** 标签ID。 */
        @JsonProperty("labelId")
        private String labelId;

        /** 标签值内容。 */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getLabelId() {
            return this.labelId;
        }

        public void setLabelId(String labelId) {
            this.labelId = labelId;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}
