package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 变更分布式缓存Redis实例规格：支持实例类型变更；规格/分片规格扩容；规格/分片规格缩容；增加分片；减少分片；增加副本；减少副本。 */
public class Dcs2ModifyInstanceSpecApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2ModifyInstanceSpecApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/lifeCycleServant/modifyInstanceSpec",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ModifyInstanceSpecResponse send(Credential credential, ModifyInstanceSpecRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ModifyInstanceSpecResponse.class);
    }

    public static class ModifyInstanceSpecRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 实例变更类型，可选值：<br>
         * <br>
         * <b>架构变更</b>
         * <li><strong>UPGRADE</strong>：架构变更（说明：单机→主备，集群单机→集群主备时，内存容量不可变更）。<br>
         *     <b>纵向扩展</b>
         * <li><strong>EXPANSION</strong>：实例/分片规格扩容（适用：Single/Dual/StandardSingle/StandardDual/DirectClusterSingle/DirectCluster/ClusterOriginalProxy/OriginalMultipleReadLvs）。
         * <li><strong>CONTRACTION</strong>：实例/分片规格缩容（适用：同上）。<br>
         *     <br>
         *     <b>横向扩展</b>
         * <li><strong>INCREASE_SHARDS</strong>：增加集群分片（适用：DirectClusterSingle/DirectCluster/ClusterOriginalProxy）。
         * <li><strong>DECREASE_SHARDS</strong>：减少集群分片（适用：同上）。<br>
         *     <br>
         *     <b>副本调整</b>
         * <li><strong>INCREASE_REPLICAS</strong>：增加数据副本（适用：StandardDual/DirectCluster/ClusterOriginalProxy/OriginalMultipleReadLvs）。
         * <li><strong>DECREASE_REPLICAS</strong>：减少数据副本（适用：同上）。
         */
        @JsonProperty("orderType")
        private String orderType;

        /**
         * 是否自动支付（仅对包周期实例有效）：
         * <li>true：自动付费。
         * <li>false：手动付费(默认值)。<br>
         *     说明：选择为手动付费时，您需要在控制台的顶部菜单栏进入费用 > 待支付订单页面，找到目标订单进行支付。
         */
        @JsonProperty("autoPay")
        private Boolean autoPay;

        /**
         * 备可用区名称，可调用 <a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=17764&isNormal=1&vid=270">查询可用区信息</a>
         * 使用name字段，新增副本时必填，实例仅允许最多两个可用区。
         */
        @JsonProperty("secondaryZoneName")
        private String secondaryZoneName;

        /**
         * 目标实例类型，例如 StandardSingle 为单机版实例，详细信息请参见 <a target="_blank"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。
         */
        @JsonProperty("edition")
        private String edition;

        /**
         * 目标实例的分片规格，单位为 GB，详细信息请参见 <a target="_blank"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。
         */
        @JsonProperty("shardMemSize")
        private String shardMemSize;

        /**
         * 目标实例的分片数，详细信息请参见 <a target="_blank"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a> ， 取值范围如下：
         * <li>当 edition 取值为 DirectClusterSingle/DirectCluster/ClusterOriginalProxy时: 3~256。
         * <li>当 edition 取其他值时无需填写。
         */
        @JsonProperty("shardCount")
        private Integer shardCount;

        /**
         * 目标实例的存储容量，单位为 GB，仅当实例版本类型为 Classic：经典版 时填写，详细信息请参见 <a target="_blank"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。
         */
        @JsonProperty("capacity")
        private String capacity;

        /**
         * 副本数，取值范围2~10，详细信息请参见 <a target="_blank"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。
         * <li>当 edition 取值为 OriginalMultipleReadLvs时必填。
         * <li>当 edition 取值为 StandardDual/DirectCluster/ClusterOriginalProxy时选填。<br>
         *     当 edition 取其他值时无需填写。
         */
        @JsonProperty("copiesCount")
        private Integer copiesCount;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getOrderType() {
            return this.orderType;
        }

        public void setOrderType(String orderType) {
            this.orderType = orderType;
        }

        public Boolean getAutoPay() {
            return this.autoPay;
        }

        public void setAutoPay(Boolean autoPay) {
            this.autoPay = autoPay;
        }

        public String getSecondaryZoneName() {
            return this.secondaryZoneName;
        }

        public void setSecondaryZoneName(String secondaryZoneName) {
            this.secondaryZoneName = secondaryZoneName;
        }

        public String getEdition() {
            return this.edition;
        }

        public void setEdition(String edition) {
            this.edition = edition;
        }

        public String getShardMemSize() {
            return this.shardMemSize;
        }

        public void setShardMemSize(String shardMemSize) {
            this.shardMemSize = shardMemSize;
        }

        public Integer getShardCount() {
            return this.shardCount;
        }

        public void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        public String getCapacity() {
            return this.capacity;
        }

        public void setCapacity(String capacity) {
            this.capacity = capacity;
        }

        public Integer getCopiesCount() {
            return this.copiesCount;
        }

        public void setCopiesCount(Integer copiesCount) {
            this.copiesCount = copiesCount;
        }
    }

    public static class ModifyInstanceSpecResponse {
        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 返回对象 */
        @JsonProperty("returnObj")
        private ModifyInstanceSpecReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public ModifyInstanceSpecReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ModifyInstanceSpecReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ModifyInstanceSpecReturnObjResponse {
        /** 错误信息。 */
        @JsonProperty("errorMessage")
        private String errorMessage;

        /** 是否提交成功 */
        @JsonProperty("submitted")
        private Boolean submitted;

        /** 新订单ID。 */
        @JsonProperty("newOrderId")
        private String newOrderId;

        /** 新订单号。 */
        @JsonProperty("newOrderNo")
        private String newOrderNo;

        /** 包周期实例展示计费周期内的价格差，按需实例不展示价格。 */
        @JsonProperty("totalPrice")
        private Double totalPrice;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Boolean getSubmitted() {
            return this.submitted;
        }

        public void setSubmitted(Boolean submitted) {
            this.submitted = submitted;
        }

        public String getNewOrderId() {
            return this.newOrderId;
        }

        public void setNewOrderId(String newOrderId) {
            this.newOrderId = newOrderId;
        }

        public String getNewOrderNo() {
            return this.newOrderNo;
        }

        public void setNewOrderNo(String newOrderNo) {
            this.newOrderNo = newOrderNo;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }
    }
}
