package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 修改分布式缓存Redis实例的参数配置。 */
public class Dcs2ModifyInstanceConfigApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2ModifyInstanceConfigApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v3/instanceParam/modifyInstanceConfig",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ModifyInstanceConfigResponse send(
            Credential credential, ModifyInstanceConfigRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ModifyInstanceConfigResponse.class);
    }

    public static class ModifyInstanceConfigRequest {
        /**
         * 资源池ID，可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口，使用resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID。 */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 参数列表。 */
        @JsonProperty("params")
        private List<ModifyInstanceConfigParamsRequest> params;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public List<ModifyInstanceConfigParamsRequest> getParams() {
            return this.params;
        }

        public void setParams(List<ModifyInstanceConfigParamsRequest> params) {
            this.params = params;
        }
    }

    public static class ModifyInstanceConfigParamsRequest {
        /**
         * 参数名称。可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=15097&isNormal=1&vid=270">查询实例配置参数</a>
         * 接口，使用param表paramName字段。
         */
        @JsonProperty("paramName")
        private String paramName;

        /** 当前值。 */
        @JsonProperty("currentValue")
        private String currentValue;

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(String currentValue) {
            this.currentValue = currentValue;
        }
    }

    public static class ModifyInstanceConfigResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private ModifyInstanceConfigReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码描述。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ModifyInstanceConfigReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ModifyInstanceConfigReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ModifyInstanceConfigReturnObjResponse {}
}
