package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 设置热key自动分析策略。 */
public class Dcs2ModifyHotKeyPolicyApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2ModifyHotKeyPolicyApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/keyAnalysisMgrServant/modifyHotKeyPolicy",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ModifyHotKeyPolicyResponse send(Credential credential, ModifyHotKeyPolicyRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ModifyHotKeyPolicyResponse.class);
    }

    public static class ModifyHotKeyPolicyRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 指某日某个时刻自动分析，操作类型可选值：
         * <li>0：开启自动扫描配置。
         * <li>1：关闭自动扫描配置。
         * <li>2：修改自动扫描配置。其中modifyType 与
         *     autoCycleType互斥，代表只能开启其中一种自动扫描方式，即自动在某个日期某个时刻自动分析，还是自动每半个小时开启自动分析
         */
        @JsonProperty("modifyType")
        private String modifyType;

        /**
         * 日期范围，1-7表示周一至周日，多个日期使用英文逗号分隔。<br>
         * 说明：modifyType=1关闭自动扫描配置可不填写。
         */
        @JsonProperty("days")
        private String days;

        /**
         * 整点时刻。<br>
         * 说明：关闭自动扫描配置可不填写。
         */
        @JsonProperty("hours")
        private String hours;

        /**
         * 指周期每半个小时自动分析，操作类型可选值：
         * <li>0：开启周期扫描配置，
         * <li>1：关闭周期扫描配置，其中autoCycleType 与 modifyType
         *     互斥，代表只能开启其中一种自动扫描方式，即自动每半个小时开启自动分析，还是自动在某个日期某个时刻自动分析
         */
        @JsonProperty("autoCycleType")
        private String autoCycleType;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getModifyType() {
            return this.modifyType;
        }

        public void setModifyType(String modifyType) {
            this.modifyType = modifyType;
        }

        public String getDays() {
            return this.days;
        }

        public void setDays(String days) {
            this.days = days;
        }

        public String getHours() {
            return this.hours;
        }

        public void setHours(String hours) {
            this.hours = hours;
        }

        public String getAutoCycleType() {
            return this.autoCycleType;
        }

        public void setAutoCycleType(String autoCycleType) {
            this.autoCycleType = autoCycleType;
        }
    }

    public static class ModifyHotKeyPolicyResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 无返回数据，空对象。 */
        @JsonProperty("returnObj")
        private ModifyHotKeyPolicyReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ModifyHotKeyPolicyReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ModifyHotKeyPolicyReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ModifyHotKeyPolicyReturnObjResponse {}
}
