package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询任务列表。 */
public class Dcs2ListTasksApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2ListTasksApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v2/taskCenter/listTasks", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListTasksResponse send(Credential credential, ListTasksRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListTasksResponse.class);
    }

    public static class ListTasksRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 开始时间（yyyyMMdd）。 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间（yyyyMMdd）（最长时间跨度：31天）。 */
        @JsonProperty("endTime")
        private String endTime;

        /** 页码（默认：1）。 */
        @JsonProperty("pageIndex")
        private Integer pageIndex;

        /** 每页条数（默认：10，范围：1~100）。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 查询条件。 */
        @JsonProperty("condition")
        private ListTasksConditionRequest condition;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public Integer getPageIndex() {
            return this.pageIndex;
        }

        public void setPageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public ListTasksConditionRequest getCondition() {
            return this.condition;
        }

        public void setCondition(ListTasksConditionRequest condition) {
            this.condition = condition;
        }
    }

    public static class ListTasksConditionRequest {
        /** 任务类型。默认空值查询所有任务，输入指定taskType查询指定任务类型，多个类型用英文逗号分割。taskType可选值见枚举值taskType表。 */
        @JsonProperty("taskTypeStr")
        private String taskTypeStr;

        /**
         * 查询指定任务状态。
         * <li>-1：所有状态的任务。
         * <li>0：初始态任务。
         * <li>1：运行中的任务。
         * <li>2：成功的任务。
         * <li>3：失败的任务。
         * <li>4：取消的任务。
         */
        @JsonProperty("status")
        private Integer status;

        /** 查询指定实例ID的任务列表。 */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 返回数据的排序。
         * <li>0：按创建时间自然排序。
         * <li>1：按创建时间降序排序。
         */
        @JsonProperty("startTimeDesc")
        private Integer startTimeDesc;

        public String getTaskTypeStr() {
            return this.taskTypeStr;
        }

        public void setTaskTypeStr(String taskTypeStr) {
            this.taskTypeStr = taskTypeStr;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Integer getStartTimeDesc() {
            return this.startTimeDesc;
        }

        public void setStartTimeDesc(Integer startTimeDesc) {
            this.startTimeDesc = startTimeDesc;
        }
    }

    public static class ListTasksResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private ListTasksReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ListTasksReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListTasksReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ListTasksReturnObjResponse {
        /** 总数。 */
        @JsonProperty("total")
        private Integer total;

        /** 任务信息列表。 */
        @JsonProperty("rows")
        private List<ListTasksReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<ListTasksReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<ListTasksReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class ListTasksReturnObjRowsResponse {
        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        /** 实例ID。 */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 任务类型，taskType说明见枚举值taskType表。 */
        @JsonProperty("taskType")
        private Integer taskType;

        /** 任务类型描述。 */
        @JsonProperty("taskTypeDesc")
        private String taskTypeDesc;

        /**
         * 任务状态。
         * <li>0：初始态。
         * <li>1：运行中。
         * <li>2：成功。
         * <li>3：失败。
         * <li>4：取消。
         */
        @JsonProperty("status")
        private Integer status;

        /** 任务开始时间戳（秒）。 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 任务结束时间戳（秒），0 表示任务未结束或者结束时间未知。 */
        @JsonProperty("endTime")
        private Long endTime;

        /** 任务备注。 */
        @JsonProperty("detail")
        private List<String> detail;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Integer getTaskType() {
            return this.taskType;
        }

        public void setTaskType(Integer taskType) {
            this.taskType = taskType;
        }

        public String getTaskTypeDesc() {
            return this.taskTypeDesc;
        }

        public void setTaskTypeDesc(String taskTypeDesc) {
            this.taskTypeDesc = taskTypeDesc;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public List<String> getDetail() {
            return this.detail;
        }

        public void setDetail(List<String> detail) {
            this.detail = detail;
        }
    }
}
