package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询数据迁移任务列表 */
public class Dcs2ListTaskInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2ListTaskInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v2/transfer/listTaskInfo", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListTaskInfoResponse send(Credential credential, ListTaskInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", request.pageNum);
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", request.pageSize);
            request.pageSize = null;
        }
        if (request.status != null) {
            ctReq.addParam("status", request.status);
            request.status = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListTaskInfoResponse.class);
    }

    public static class ListTaskInfoRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 页码（范围：> 0）。 */
        @JsonProperty("pageNum")
        private String pageNum;

        /** 数量（范围：[1,100]）。 */
        @JsonProperty("pageSize")
        private String pageSize;

        /**
         * 查询指定的任务状态，可选值：
         * <li>0：所有状态（默认）。
         * <li>1：运行中。
         * <li>2：成功。
         * <li>3：失败。
         */
        @JsonProperty("status")
        private String status;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(String pageNum) {
            this.pageNum = pageNum;
        }

        public String getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(String pageSize) {
            this.pageSize = pageSize;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }

    public static class ListTaskInfoResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private ListTaskInfoReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ListTaskInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListTaskInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ListTaskInfoReturnObjResponse {
        /** 总数。 */
        @JsonProperty("total")
        private Integer total;

        /** 当前页数量。 */
        @JsonProperty("size")
        private Integer size;

        /** 迁移任务列表。 */
        @JsonProperty("list")
        private List<ListTaskInfoReturnObjListResponse> list;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public List<ListTaskInfoReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<ListTaskInfoReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class ListTaskInfoReturnObjListResponse {
        /** 用户ID。 */
        @JsonProperty("userId")
        private String userId;

        /** 租户ID。 */
        @JsonProperty("tenantId")
        private String tenantId;

        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        /**
         * 源库实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("sourceSpuInstId")
        private String sourceSpuInstId;

        /**
         * 目标库实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("targetSpuInstId")
        private String targetSpuInstId;

        /** 类型。 */
        @JsonProperty("type")
        private Integer type;

        /**
         * 任务状态。
         * <li>0：初始态。
         * <li>1：运行中。
         * <li>2：成功。
         * <li>3：失败。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 迁移进度。
         * <li>1：全量同步中。
         * <li>2：增量同步中。
         */
        @JsonProperty("runStep")
        private Integer runStep;

        /** 创建时间戳（秒）。 */
        @JsonProperty("createTime")
        private Long createTime;

        /** 结束时间戳（秒，=-1时表示时间未知）。 */
        @JsonProperty("completeTime")
        private Long completeTime;

        /** 详情。 */
        @JsonProperty("detail")
        private ListTaskInfoReturnObjListDetailResponse detail;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getSourceSpuInstId() {
            return this.sourceSpuInstId;
        }

        public void setSourceSpuInstId(String sourceSpuInstId) {
            this.sourceSpuInstId = sourceSpuInstId;
        }

        public String getTargetSpuInstId() {
            return this.targetSpuInstId;
        }

        public void setTargetSpuInstId(String targetSpuInstId) {
            this.targetSpuInstId = targetSpuInstId;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getRunStep() {
            return this.runStep;
        }

        public void setRunStep(Integer runStep) {
            this.runStep = runStep;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        public Long getCompleteTime() {
            return this.completeTime;
        }

        public void setCompleteTime(Long completeTime) {
            this.completeTime = completeTime;
        }

        public ListTaskInfoReturnObjListDetailResponse getDetail() {
            return this.detail;
        }

        public void setDetail(ListTaskInfoReturnObjListDetailResponse detail) {
            this.detail = detail;
        }
    }

    public static class ListTaskInfoReturnObjListDetailResponse {
        /** 源库信息。 */
        @JsonProperty("sourceDbInfo")
        private ListTaskInfoReturnObjListDetailSourceDbInfoResponse sourceDbInfo;

        /** 目标库信息。 */
        @JsonProperty("targetDbInfo")
        private ListTaskInfoReturnObjListDetailTargetDbInfoResponse targetDbInfo;

        public ListTaskInfoReturnObjListDetailSourceDbInfoResponse getSourceDbInfo() {
            return this.sourceDbInfo;
        }

        public void setSourceDbInfo(
                ListTaskInfoReturnObjListDetailSourceDbInfoResponse sourceDbInfo) {
            this.sourceDbInfo = sourceDbInfo;
        }

        public ListTaskInfoReturnObjListDetailTargetDbInfoResponse getTargetDbInfo() {
            return this.targetDbInfo;
        }

        public void setTargetDbInfo(
                ListTaskInfoReturnObjListDetailTargetDbInfoResponse targetDbInfo) {
            this.targetDbInfo = targetDbInfo;
        }
    }

    public static class ListTaskInfoReturnObjListDetailSourceDbInfoResponse {
        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("spuInstId")
        private String spuInstId;

        /** 连接地址。 */
        @JsonProperty("ipAddr")
        private String ipAddr;

        /** 是否是原生cluster集群。 */
        @JsonProperty("originalCluster")
        private Boolean originalCluster;

        /** 数据库账号。 */
        @JsonProperty("accountName")
        private String accountName;

        /** 数据库密码。 */
        @JsonProperty("password")
        private String password;

        /** 实例名称。 */
        @JsonProperty("instanceName")
        private String instanceName;

        public String getSpuInstId() {
            return this.spuInstId;
        }

        public void setSpuInstId(String spuInstId) {
            this.spuInstId = spuInstId;
        }

        public String getIpAddr() {
            return this.ipAddr;
        }

        public void setIpAddr(String ipAddr) {
            this.ipAddr = ipAddr;
        }

        public Boolean getOriginalCluster() {
            return this.originalCluster;
        }

        public void setOriginalCluster(Boolean originalCluster) {
            this.originalCluster = originalCluster;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }
    }

    public static class ListTaskInfoReturnObjListDetailTargetDbInfoResponse {
        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("spuInstId")
        private String spuInstId;

        /** 连接地址。 */
        @JsonProperty("ipAddr")
        private String ipAddr;

        /** 是否是原生cluster集群。 */
        @JsonProperty("originalCluster")
        private Boolean originalCluster;

        /** 数据库账号。 */
        @JsonProperty("accountName")
        private String accountName;

        /** 数据库密码。 */
        @JsonProperty("password")
        private String password;

        /** 实例名称。 */
        @JsonProperty("instanceName")
        private String instanceName;

        public String getSpuInstId() {
            return this.spuInstId;
        }

        public void setSpuInstId(String spuInstId) {
            this.spuInstId = spuInstId;
        }

        public String getIpAddr() {
            return this.ipAddr;
        }

        public void setIpAddr(String ipAddr) {
            this.ipAddr = ipAddr;
        }

        public Boolean getOriginalCluster() {
            return this.originalCluster;
        }

        public void setOriginalCluster(Boolean originalCluster) {
            this.originalCluster = originalCluster;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }
    }
}
