package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询分布式缓存Redis实例故障列表。 */
public class Dcs2ListInstanceExperimentsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2ListInstanceExperimentsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/inject/listInstanceExperiments", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ListInstanceExperimentsResponse send(
            Credential credential, ListInstanceExperimentsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.page != null) {
            ctReq.addParam("page", request.page);
            request.page = null;
        }
        if (request.size != null) {
            ctReq.addParam("size", request.size);
            request.size = null;
        }
        if (request.actionCode != null) {
            ctReq.addParam("actionCode", request.actionCode);
            request.actionCode = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ListInstanceExperimentsResponse.class);
    }

    public static class ListInstanceExperimentsRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 当前页,最小值为1, 默认1。 */
        @JsonProperty("page")
        private String page;

        /** 当前页大小,范围[1, 100]，默认10 。 */
        @JsonProperty("size")
        private String size;

        /**
         * 故障类型，可选值：
         * <li>memory-load: 内存负载。
         * <li>cpu-fullload：CPU满载注入。
         * <li>disk-burn: 磁盘IO Utilization。
         * <li>node-shutdown: 主机宕机
         * <li>network-loss: 网络丢包。
         */
        @JsonProperty("actionCode")
        private String actionCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getPage() {
            return this.page;
        }

        public void setPage(String page) {
            this.page = page;
        }

        public String getSize() {
            return this.size;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getActionCode() {
            return this.actionCode;
        }

        public void setActionCode(String actionCode) {
            this.actionCode = actionCode;
        }
    }

    public static class ListInstanceExperimentsResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private ListInstanceExperimentsReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ListInstanceExperimentsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ListInstanceExperimentsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ListInstanceExperimentsReturnObjResponse {
        /** 总条数。 */
        @JsonProperty("total")
        private Integer total;

        /** InstanceExperimentDetail对象数组。 */
        @JsonProperty("list")
        private List<ListInstanceExperimentsReturnObjListResponse> list;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<ListInstanceExperimentsReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<ListInstanceExperimentsReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class ListInstanceExperimentsReturnObjListResponse {
        /** 故障演练ID。 */
        @JsonProperty("experimentId")
        private String experimentId;

        /** 故障动作。 */
        @JsonProperty("action")
        private ListInstanceExperimentsReturnObjListActionResponse action;

        /** 演练创建时间。 */
        @JsonProperty("createDate")
        private Long createDate;

        /** 故障注入任务。 */
        @JsonProperty("injectActionInstance")
        private ListInstanceExperimentsReturnObjListInjectActionInstanceResponse
                injectActionInstance;

        /** 故障撤销任务。 */
        @JsonProperty("recoveryActionInstance")
        private ListInstanceExperimentsReturnObjListRecoveryActionInstanceResponse
                recoveryActionInstance;

        public String getExperimentId() {
            return this.experimentId;
        }

        public void setExperimentId(String experimentId) {
            this.experimentId = experimentId;
        }

        public ListInstanceExperimentsReturnObjListActionResponse getAction() {
            return this.action;
        }

        public void setAction(ListInstanceExperimentsReturnObjListActionResponse action) {
            this.action = action;
        }

        public Long getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(Long createDate) {
            this.createDate = createDate;
        }

        public ListInstanceExperimentsReturnObjListInjectActionInstanceResponse
        getInjectActionInstance() {
            return this.injectActionInstance;
        }

        public void setInjectActionInstance(
                ListInstanceExperimentsReturnObjListInjectActionInstanceResponse
                        injectActionInstance) {
            this.injectActionInstance = injectActionInstance;
        }

        public ListInstanceExperimentsReturnObjListRecoveryActionInstanceResponse
        getRecoveryActionInstance() {
            return this.recoveryActionInstance;
        }

        public void setRecoveryActionInstance(
                ListInstanceExperimentsReturnObjListRecoveryActionInstanceResponse
                        recoveryActionInstance) {
            this.recoveryActionInstance = recoveryActionInstance;
        }
    }

    public static class ListInstanceExperimentsReturnObjListActionResponse {
        /**
         * 故障范围。
         * <li>cluster：集群范围。
         * <li>host：主机范围。
         * <li>net：网络范围。
         */
        @JsonProperty("actionScope")
        private String actionScope;

        /** 故障类型。 */
        @JsonProperty("actionCode")
        private String actionCode;

        /** 动作执行参数。 */
        @JsonProperty("actionParameter")
        private List<ListInstanceExperimentsReturnObjListActionActionParameterResponse>
                actionParameter;

        public String getActionScope() {
            return this.actionScope;
        }

        public void setActionScope(String actionScope) {
            this.actionScope = actionScope;
        }

        public String getActionCode() {
            return this.actionCode;
        }

        public void setActionCode(String actionCode) {
            this.actionCode = actionCode;
        }

        public List<ListInstanceExperimentsReturnObjListActionActionParameterResponse>
        getActionParameter() {
            return this.actionParameter;
        }

        public void setActionParameter(
                List<ListInstanceExperimentsReturnObjListActionActionParameterResponse>
                        actionParameter) {
            this.actionParameter = actionParameter;
        }
    }

    public static class ListInstanceExperimentsReturnObjListInjectActionInstanceResponse {
        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        /** 故障类型。 */
        @JsonProperty("actionCode")
        private String actionCode;

        /**
         * 动作执行状态。
         * <li>0：执行完成。
         * <li>1：执行失败。
         * <li>2：执行中。
         * <li>3：未开始。
         */
        @JsonProperty("state")
        private Integer state;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("instanceId")
        private String instanceId;

        /**
         * 实例类型。
         * <li>ctg-redis：缓存。
         * <li>ctg-ecs：云主机。
         */
        @JsonProperty("resourceType")
        private String resourceType;

        /** 开始时间戳。 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 结束时间戳。 */
        @JsonProperty("endTime")
        private Long endTime;

        /** 动作参数。 */
        @JsonProperty("actionParameter")
        private List<
                ListInstanceExperimentsReturnObjListInjectActionInstanceActionParameterResponse>
                actionParameter;

        /** 动作执行日志。 */
        @JsonProperty("logs")
        private List<ListInstanceExperimentsReturnObjListInjectActionInstanceLogsResponse> logs;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getActionCode() {
            return this.actionCode;
        }

        public void setActionCode(String actionCode) {
            this.actionCode = actionCode;
        }

        public Integer getState() {
            return this.state;
        }

        public void setState(Integer state) {
            this.state = state;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public List<ListInstanceExperimentsReturnObjListInjectActionInstanceActionParameterResponse>
        getActionParameter() {
            return this.actionParameter;
        }

        public void setActionParameter(
                List<
                        ListInstanceExperimentsReturnObjListInjectActionInstanceActionParameterResponse>
                        actionParameter) {
            this.actionParameter = actionParameter;
        }

        public List<ListInstanceExperimentsReturnObjListInjectActionInstanceLogsResponse>
        getLogs() {
            return this.logs;
        }

        public void setLogs(
                List<ListInstanceExperimentsReturnObjListInjectActionInstanceLogsResponse> logs) {
            this.logs = logs;
        }
    }

    public static class ListInstanceExperimentsReturnObjListRecoveryActionInstanceResponse {
        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        /** 故障类型。 */
        @JsonProperty("actionCode")
        private String actionCode;

        /**
         * 动作执行状态。
         * <li>0：执行完成。
         * <li>1：执行失败。
         * <li>2：执行中。
         * <li>3：未开始。
         */
        @JsonProperty("state")
        private Integer state;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("instanceId")
        private String instanceId;

        /**
         * 实例类型。
         * <li>ctg-redis：缓存。
         * <li>ctg-ecs：云主机。
         */
        @JsonProperty("resourceType")
        private String resourceType;

        /** 开始时间戳。 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 结束时间戳。 */
        @JsonProperty("endTime")
        private Long endTime;

        /** 动作参数。 */
        @JsonProperty("actionParameter")
        private List<
                ListInstanceExperimentsReturnObjListRecoveryActionInstanceActionParameterResponse>
                actionParameter;

        /** 动作执行日志。 */
        @JsonProperty("logs")
        private List<ListInstanceExperimentsReturnObjListRecoveryActionInstanceLogsResponse> logs;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getActionCode() {
            return this.actionCode;
        }

        public void setActionCode(String actionCode) {
            this.actionCode = actionCode;
        }

        public Integer getState() {
            return this.state;
        }

        public void setState(Integer state) {
            this.state = state;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public List<
                ListInstanceExperimentsReturnObjListRecoveryActionInstanceActionParameterResponse>
        getActionParameter() {
            return this.actionParameter;
        }

        public void setActionParameter(
                List<
                        ListInstanceExperimentsReturnObjListRecoveryActionInstanceActionParameterResponse>
                        actionParameter) {
            this.actionParameter = actionParameter;
        }

        public List<ListInstanceExperimentsReturnObjListRecoveryActionInstanceLogsResponse>
        getLogs() {
            return this.logs;
        }

        public void setLogs(
                List<ListInstanceExperimentsReturnObjListRecoveryActionInstanceLogsResponse> logs) {
            this.logs = logs;
        }
    }

    public static class ListInstanceExperimentsReturnObjListActionActionParameterResponse {
        /** 通用参数。 */
        @JsonProperty("code")
        private String code;

        /** 参数值。 */
        @JsonProperty("value")
        private String value;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static
    class ListInstanceExperimentsReturnObjListInjectActionInstanceActionParameterResponse {
        /** 通用参数。 */
        @JsonProperty("code")
        private String code;

        /** 参数值。 */
        @JsonProperty("value")
        private String value;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class ListInstanceExperimentsReturnObjListInjectActionInstanceLogsResponse {
        /** 日志内容。 */
        @JsonProperty("msg")
        private String msg;

        /** 日志时间。 */
        @JsonProperty("logTime")
        private Long logTime;

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public Long getLogTime() {
            return this.logTime;
        }

        public void setLogTime(Long logTime) {
            this.logTime = logTime;
        }
    }

    public static
    class ListInstanceExperimentsReturnObjListRecoveryActionInstanceActionParameterResponse {
        /** 通用参数。 */
        @JsonProperty("code")
        private String code;

        /** 参数值。 */
        @JsonProperty("value")
        private String value;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class ListInstanceExperimentsReturnObjListRecoveryActionInstanceLogsResponse {
        /** 日志内容。 */
        @JsonProperty("msg")
        private String msg;

        /** 日志时间。 */
        @JsonProperty("logTime")
        private Long logTime;

        public String getMsg() {
            return this.msg;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public Long getLogTime() {
            return this.logTime;
        }

        public void setLogTime(Long logTime) {
            this.logTime = logTime;
        }
    }
}
