package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询迁移任务详情。 */
public class Dcs2GetTransferTaskInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2GetTransferTaskInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v2/transfer/getTaskInfo", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetTransferTaskInfoResponse send(
            Credential credential, GetTransferTaskInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.taskId != null) {
            ctReq.addParam("taskId", request.taskId);
            request.taskId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetTransferTaskInfoResponse.class);
    }

    public static class GetTransferTaskInfoRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }

    public static class GetTransferTaskInfoResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private GetTransferTaskInfoReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetTransferTaskInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetTransferTaskInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetTransferTaskInfoReturnObjResponse {
        /** 用户ID。 */
        @JsonProperty("userId")
        private String userId;

        /** 租户ID。 */
        @JsonProperty("tenantId")
        private String tenantId;

        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        /**
         * 源库实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("sourceSpuInstId")
        private String sourceSpuInstId;

        /**
         * 目标库实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("targetSpuInstId")
        private String targetSpuInstId;

        /**
         * 同步模式。
         * <li>1：全量同步+增量同步。
         * <li>2：全量同步。
         */
        @JsonProperty("syncMode")
        private Integer syncMode;

        /** 任务类型（1：数据迁移任务，其他：未知；本接口该字段固定返回1）。 */
        @JsonProperty("type")
        private Integer type;

        /**
         * 数据冲突时的处理办法。
         * <li>1：中断迁移。
         * <li>2：跳过目标key，继续执行。
         * <li>3：覆盖目标key，继续执行。
         */
        @JsonProperty("conflictMode")
        private Integer conflictMode;

        /**
         * 任务状态。
         * <li>0：初始态。
         * <li>1：运行中。
         * <li>2：成功。
         * <li>3：失败。
         */
        @JsonProperty("status")
        private Integer status;

        /**
         * 迁移进度。
         * <li>1：全量同步中。
         * <li>2：增量同步中。
         */
        @JsonProperty("runStep")
        private Integer runStep;

        /** 创建时间(秒)。 */
        @JsonProperty("createTime")
        private Long createTime;

        /** 结束时间（秒，-1表示时间未知）。 */
        @JsonProperty("completeTime")
        private Long completeTime;

        /** 详情。 */
        @JsonProperty("detail")
        private GetTransferTaskInfoReturnObjDetailResponse detail;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getSourceSpuInstId() {
            return this.sourceSpuInstId;
        }

        public void setSourceSpuInstId(String sourceSpuInstId) {
            this.sourceSpuInstId = sourceSpuInstId;
        }

        public String getTargetSpuInstId() {
            return this.targetSpuInstId;
        }

        public void setTargetSpuInstId(String targetSpuInstId) {
            this.targetSpuInstId = targetSpuInstId;
        }

        public Integer getSyncMode() {
            return this.syncMode;
        }

        public void setSyncMode(Integer syncMode) {
            this.syncMode = syncMode;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Integer getConflictMode() {
            return this.conflictMode;
        }

        public void setConflictMode(Integer conflictMode) {
            this.conflictMode = conflictMode;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getRunStep() {
            return this.runStep;
        }

        public void setRunStep(Integer runStep) {
            this.runStep = runStep;
        }

        public Long getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(Long createTime) {
            this.createTime = createTime;
        }

        public Long getCompleteTime() {
            return this.completeTime;
        }

        public void setCompleteTime(Long completeTime) {
            this.completeTime = completeTime;
        }

        public GetTransferTaskInfoReturnObjDetailResponse getDetail() {
            return this.detail;
        }

        public void setDetail(GetTransferTaskInfoReturnObjDetailResponse detail) {
            this.detail = detail;
        }
    }

    public static class GetTransferTaskInfoReturnObjDetailResponse {
        /** 源库信息。 */
        @JsonProperty("sourceDbInfo")
        private GetTransferTaskInfoReturnObjDetailSourceDbInfoResponse sourceDbInfo;

        /** 目标库信息。 */
        @JsonProperty("targetDbInfo")
        private GetTransferTaskInfoReturnObjDetailTargetDbInfoResponse targetDbInfo;

        public GetTransferTaskInfoReturnObjDetailSourceDbInfoResponse getSourceDbInfo() {
            return this.sourceDbInfo;
        }

        public void setSourceDbInfo(
                GetTransferTaskInfoReturnObjDetailSourceDbInfoResponse sourceDbInfo) {
            this.sourceDbInfo = sourceDbInfo;
        }

        public GetTransferTaskInfoReturnObjDetailTargetDbInfoResponse getTargetDbInfo() {
            return this.targetDbInfo;
        }

        public void setTargetDbInfo(
                GetTransferTaskInfoReturnObjDetailTargetDbInfoResponse targetDbInfo) {
            this.targetDbInfo = targetDbInfo;
        }
    }

    public static class GetTransferTaskInfoReturnObjDetailSourceDbInfoResponse {
        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("spuInstId")
        private String spuInstId;

        /** 连接地址。 */
        @JsonProperty("ipAddr")
        private String ipAddr;

        /** 是否是原生cluster集群。 */
        @JsonProperty("originalCluster")
        private Boolean originalCluster;

        /** 数据库账号。 */
        @JsonProperty("accountName")
        private String accountName;

        /** 数据库密码。 */
        @JsonProperty("password")
        private String password;

        /** 实例名称。 */
        @JsonProperty("instanceName")
        private String instanceName;

        public String getSpuInstId() {
            return this.spuInstId;
        }

        public void setSpuInstId(String spuInstId) {
            this.spuInstId = spuInstId;
        }

        public String getIpAddr() {
            return this.ipAddr;
        }

        public void setIpAddr(String ipAddr) {
            this.ipAddr = ipAddr;
        }

        public Boolean getOriginalCluster() {
            return this.originalCluster;
        }

        public void setOriginalCluster(Boolean originalCluster) {
            this.originalCluster = originalCluster;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }
    }

    public static class GetTransferTaskInfoReturnObjDetailTargetDbInfoResponse {
        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("spuInstId")
        private String spuInstId;

        /** 连接地址。 */
        @JsonProperty("ipAddr")
        private String ipAddr;

        /** 是否是原生cluster集群。 */
        @JsonProperty("originalCluster")
        private Boolean originalCluster;

        /** 数据库账号。 */
        @JsonProperty("accountName")
        private String accountName;

        /** 数据库密码。 */
        @JsonProperty("password")
        private String password;

        /** 实例名称。 */
        @JsonProperty("instanceName")
        private String instanceName;

        public String getSpuInstId() {
            return this.spuInstId;
        }

        public void setSpuInstId(String spuInstId) {
            this.spuInstId = spuInstId;
        }

        public String getIpAddr() {
            return this.ipAddr;
        }

        public void setIpAddr(String ipAddr) {
            this.ipAddr = ipAddr;
        }

        public Boolean getOriginalCluster() {
            return this.originalCluster;
        }

        public void setOriginalCluster(Boolean originalCluster) {
            this.originalCluster = originalCluster;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }
    }
}
