package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询在线迁移进度明细。 */
public class Dcs2GetTaskProgressDetailInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2GetTaskProgressDetailInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/transfer/getTaskProgressDetailInfo", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetTaskProgressDetailInfoResponse send(
            Credential credential, GetTaskProgressDetailInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.taskId != null) {
            ctReq.addParam("taskId", request.taskId);
            request.taskId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetTaskProgressDetailInfoResponse.class);
    }

    public static class GetTaskProgressDetailInfoRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }

    public static class GetTaskProgressDetailInfoResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private GetTaskProgressDetailInfoReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetTaskProgressDetailInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetTaskProgressDetailInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetTaskProgressDetailInfoReturnObjResponse {
        /** 命令同步信息汇总。 */
        @JsonProperty("dataSyncCountInfo")
        private GetTaskProgressDetailInfoReturnObjDataSyncCountInfoResponse dataSyncCountInfo;

        /** 同步进度信息。 */
        @JsonProperty("sourceProgressInfoList")
        private List<GetTaskProgressDetailInfoReturnObjSourceProgressInfoListResponse>
                sourceProgressInfoList;

        public GetTaskProgressDetailInfoReturnObjDataSyncCountInfoResponse getDataSyncCountInfo() {
            return this.dataSyncCountInfo;
        }

        public void setDataSyncCountInfo(
                GetTaskProgressDetailInfoReturnObjDataSyncCountInfoResponse dataSyncCountInfo) {
            this.dataSyncCountInfo = dataSyncCountInfo;
        }

        public List<GetTaskProgressDetailInfoReturnObjSourceProgressInfoListResponse>
                getSourceProgressInfoList() {
            return this.sourceProgressInfoList;
        }

        public void setSourceProgressInfoList(
                List<GetTaskProgressDetailInfoReturnObjSourceProgressInfoListResponse>
                        sourceProgressInfoList) {
            this.sourceProgressInfoList = sourceProgressInfoList;
        }
    }

    public static class GetTaskProgressDetailInfoReturnObjDataSyncCountInfoResponse {
        /** 从源端读取的总命令数。 */
        @JsonProperty("readCount")
        private Long readCount;

        /** 从源端读取的命令总OPS。 */
        @JsonProperty("readOps")
        private Double readOps;

        /** 发送给目标的总命令数。 */
        @JsonProperty("writeCount")
        private Long writeCount;

        /** 发送给目标的命令总OPS。 */
        @JsonProperty("writeOps")
        private Double writeOps;

        public Long getReadCount() {
            return this.readCount;
        }

        public void setReadCount(Long readCount) {
            this.readCount = readCount;
        }

        public Double getReadOps() {
            return this.readOps;
        }

        public void setReadOps(Double readOps) {
            this.readOps = readOps;
        }

        public Long getWriteCount() {
            return this.writeCount;
        }

        public void setWriteCount(Long writeCount) {
            this.writeCount = writeCount;
        }

        public Double getWriteOps() {
            return this.writeOps;
        }

        public void setWriteOps(Double writeOps) {
            this.writeOps = writeOps;
        }
    }

    public static class GetTaskProgressDetailInfoReturnObjSourceProgressInfoListResponse {
        /** 源端ip:port。 */
        @JsonProperty("address")
        private String address;

        /** 全量数据的同步百分比（不包含增量）。 */
        @JsonProperty("syncPercent")
        private Double syncPercent;

        /** AOF偏移差距（增量同步时有）。 */
        @JsonProperty("aofOffsetDiff")
        private Long aofOffsetDiff;

        /**
         * 同步阶段。
         * <li>unknown status
         * <li>hand shaking
         * <li>waiting bgsave
         * <li>receiving rdb
         * <li>syncing rdb
         * <li>syncing aof（增量同步时有）
         */
        @JsonProperty("state")
        private String state;

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public Double getSyncPercent() {
            return this.syncPercent;
        }

        public void setSyncPercent(Double syncPercent) {
            this.syncPercent = syncPercent;
        }

        public Long getAofOffsetDiff() {
            return this.aofOffsetDiff;
        }

        public void setAofOffsetDiff(Long aofOffsetDiff) {
            this.aofOffsetDiff = aofOffsetDiff;
        }

        public String getState() {
            return this.state;
        }

        public void setState(String state) {
            this.state = state;
        }
    }
}
