package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询后台任务详细信息。 */
public class Dcs2GetTaskInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2GetTaskInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v2/taskCenter/getTaskInfo", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetTaskInfoResponse send(Credential credential, GetTaskInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.taskId != null) {
            ctReq.addParam("taskId", request.taskId);
            request.taskId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetTaskInfoResponse.class);
    }

    public static class GetTaskInfoRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 任务ID */
        @JsonProperty("taskId")
        private String taskId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }

    public static class GetTaskInfoResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private GetTaskInfoReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetTaskInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetTaskInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetTaskInfoReturnObjResponse {
        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        /** 实例ID。 */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 任务类型，taskType说明见枚举值taskType表。 */
        @JsonProperty("taskType")
        private Integer taskType;

        /** 任务类型描述。 */
        @JsonProperty("taskTypeDesc")
        private String taskTypeDesc;

        /**
         * 任务状态，可选值为：
         * <li>0：初始态任务。
         * <li>1：运行中的任务。
         * <li>2：成功的任务。
         * <li>3：失败的任务。
         * <li>4：取消的任务。
         * <li>其他：未知状态。
         */
        @JsonProperty("status")
        private Integer status;

        /** 开始时间戳（秒）。 */
        @JsonProperty("startTime")
        private Long startTime;

        /** 结束时间戳（秒），0 表示任务未结束或者结束时间未知。 */
        @JsonProperty("endTime")
        private Long endTime;

        /** 任务备注。 */
        @JsonProperty("detail")
        private List<String> detail;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Integer getTaskType() {
            return this.taskType;
        }

        public void setTaskType(Integer taskType) {
            this.taskType = taskType;
        }

        public String getTaskTypeDesc() {
            return this.taskTypeDesc;
        }

        public void setTaskTypeDesc(String taskTypeDesc) {
            this.taskTypeDesc = taskTypeDesc;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Long startTime) {
            this.startTime = startTime;
        }

        public Long getEndTime() {
            return this.endTime;
        }

        public void setEndTime(Long endTime) {
            this.endTime = endTime;
        }

        public List<String> getDetail() {
            return this.detail;
        }

        public void setDetail(List<String> detail) {
            this.detail = detail;
        }
    }
}
