package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询分布式缓存Redis实例绑定的标签列表。 */
public class Dcs2GetLabelListByResourcesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2GetLabelListByResourcesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/label/getLabelListByResources",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetLabelListByResourcesResponse send(
            Credential credential, GetLabelListByResourcesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetLabelListByResourcesResponse.class);
    }

    public static class GetLabelListByResourcesRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例列表。 */
        @JsonProperty("prodInstIds")
        private List<String> prodInstIds;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<String> getProdInstIds() {
            return this.prodInstIds;
        }

        public void setProdInstIds(List<String> prodInstIds) {
            this.prodInstIds = prodInstIds;
        }
    }

    public static class GetLabelListByResourcesResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private GetLabelListByResourcesReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetLabelListByResourcesReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetLabelListByResourcesReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetLabelListByResourcesReturnObjResponse {
        /** 数量。 */
        @JsonProperty("total")
        private Integer total;

        /** 绑定的产品资源。 */
        @JsonProperty("rows")
        private List<GetLabelListByResourcesReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<GetLabelListByResourcesReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<GetLabelListByResourcesReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class GetLabelListByResourcesReturnObjRowsResponse {
        /** 绑定资源数。 */
        @JsonProperty("resourceCount")
        private String resourceCount;

        /** 资源绑定的标签列表。 */
        @JsonProperty("prodResourceIdList")
        private List<GetLabelListByResourcesReturnObjRowsProdResourceIdListResponse>
                prodResourceIdList;

        public String getResourceCount() {
            return this.resourceCount;
        }

        public void setResourceCount(String resourceCount) {
            this.resourceCount = resourceCount;
        }

        public List<GetLabelListByResourcesReturnObjRowsProdResourceIdListResponse>
                getProdResourceIdList() {
            return this.prodResourceIdList;
        }

        public void setProdResourceIdList(
                List<GetLabelListByResourcesReturnObjRowsProdResourceIdListResponse>
                        prodResourceIdList) {
            this.prodResourceIdList = prodResourceIdList;
        }
    }

    public static class GetLabelListByResourcesReturnObjRowsProdResourceIdListResponse {
        /** 资源ID。 */
        @JsonProperty("resourceId")
        private String resourceId;

        public String getResourceId() {
            return this.resourceId;
        }

        public void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }
    }
}
