package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Map;

/** 获取节点客户端列表。 */
public class Dcs2GetClientIPInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2GetClientIPInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/resourceMonitor/getClientIPInfo", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public GetClientIPInfoResponse send(Credential credential, GetClientIPInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.nodeName != null) {
            ctReq.addParam("nodeName", request.nodeName);
            request.nodeName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(GetClientIPInfoResponse.class);
    }

    public static class GetClientIPInfoRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 节点名称
         * <li>实例类型为Proxy集群、经典集群版时传入proxyName<br>
         *     可调用 <a target="_blank" rel="noopener noreferrer"
         *     href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7741&isNormal=1&vid=270">查询实例的逻辑拓扑</a>
         *     接口，使用AccessNode表proxyName字段。
         * <li>其他实例类型传入Redis节点名称，可调用 <a target="_blank" rel="noopener noreferrer"
         *     href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7752&isNormal=1&vid=270">获取redis节点名列表</a>
         *     接口，使用node表nodeName字段。
         */
        @JsonProperty("nodeName")
        private String nodeName;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }
    }

    public static class GetClientIPInfoResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private GetClientIPInfoReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public GetClientIPInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(GetClientIPInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class GetClientIPInfoReturnObjResponse {
        /** 实例名称(实例ID)。 */
        @JsonProperty("instanceId")
        private String instanceId;

        /** 规格名称。 */
        @JsonProperty("skuname")
        private String skuname;

        /** 节点连接地址。 */
        @JsonProperty("nodeaddr")
        private String nodeaddr;

        /** 客户端数量。 */
        @JsonProperty("total")
        private Integer total;

        /** 活跃客户端数量。 */
        @JsonProperty("totalActives")
        private Integer totalActives;

        /** 客户端信息。 */
        @JsonProperty("clientInfoList")
        private List<GetClientIPInfoReturnObjClientInfoListResponse> clientInfoList;

        /** 返回Map格式 {客户端IP：连接数量} 键值对数据对象。 */
        @JsonProperty("clientmap")
        private Map clientmap;

        /** 返回Map格式 {命令：执行数量} 键值对数据对象。 */
        @JsonProperty("cmdmap")
        private Map cmdmap;

        /** 返回Map格式 {DB：连接数量} 键值对数据对象。 */
        @JsonProperty("dbmap")
        private Map dbmap;

        public String getInstanceId() {
            return this.instanceId;
        }

        public void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public String getSkuname() {
            return this.skuname;
        }

        public void setSkuname(String skuname) {
            this.skuname = skuname;
        }

        public String getNodeaddr() {
            return this.nodeaddr;
        }

        public void setNodeaddr(String nodeaddr) {
            this.nodeaddr = nodeaddr;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getTotalActives() {
            return this.totalActives;
        }

        public void setTotalActives(Integer totalActives) {
            this.totalActives = totalActives;
        }

        public List<GetClientIPInfoReturnObjClientInfoListResponse> getClientInfoList() {
            return this.clientInfoList;
        }

        public void setClientInfoList(
                List<GetClientIPInfoReturnObjClientInfoListResponse> clientInfoList) {
            this.clientInfoList = clientInfoList;
        }

        public Map getClientmap() {
            return this.clientmap;
        }

        public void setClientmap(Map clientmap) {
            this.clientmap = clientmap;
        }

        public Map getCmdmap() {
            return this.cmdmap;
        }

        public void setCmdmap(Map cmdmap) {
            this.cmdmap = cmdmap;
        }

        public Map getDbmap() {
            return this.dbmap;
        }

        public void setDbmap(Map dbmap) {
            this.dbmap = dbmap;
        }
    }

    public static class GetClientIPInfoReturnObjClientInfoListResponse {
        /** 连接ID。 */
        @JsonProperty("connectionId")
        private String connectionId;

        /** 客户端连接地址。 */
        @JsonProperty("addr")
        private String addr;

        /** 命令。 */
        @JsonProperty("cmd")
        private String cmd;

        /** DB编号。 */
        @JsonProperty("db")
        private String db;

        /** 过期时间。 */
        @JsonProperty("idle")
        private String idle;

        /** 连接时长。 */
        @JsonProperty("age")
        private String age;

        public String getConnectionId() {
            return this.connectionId;
        }

        public void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public String getAddr() {
            return this.addr;
        }

        public void setAddr(String addr) {
            this.addr = addr;
        }

        public String getCmd() {
            return this.cmd;
        }

        public void setCmd(String cmd) {
            this.cmd = cmd;
        }

        public String getDb() {
            return this.db;
        }

        public void setDb(String db) {
            this.db = db;
        }

        public String getIdle() {
            return this.idle;
        }

        public void setIdle(String idle) {
            this.idle = idle;
        }

        public String getAge() {
            return this.age;
        }

        public void setAge(String age) {
            this.age = age;
        }
    }
}
