package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询分布式缓存Redis实例历史慢日志，支持查询14天内的慢日志。 */
public class Dcs2FindHistorySlowLogApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2FindHistorySlowLogApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/resourceMonitor/findHistorySlowLog", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public FindHistorySlowLogResponse send(Credential credential, FindHistorySlowLogRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.nodeName != null) {
            ctReq.addParam("nodeName", request.nodeName);
            request.nodeName = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", request.startTime);
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        if (request.page != null) {
            ctReq.addParam("page", String.valueOf(request.page));
            request.page = null;
        }
        if (request.rows != null) {
            ctReq.addParam("rows", String.valueOf(request.rows));
            request.rows = null;
        }
        if (request.minCost != null) {
            ctReq.addParam("minCost", String.valueOf(request.minCost));
            request.minCost = null;
        }
        if (request.maxCost != null) {
            ctReq.addParam("maxCost", String.valueOf(request.maxCost));
            request.maxCost = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(FindHistorySlowLogResponse.class);
    }

    public static class FindHistorySlowLogRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 节点名称（查询多个时，英文逗号拼接传输）
         * <li>实例类型为Proxy集群、经典集群版时传入proxyName，可调用 <a target="_blank" rel="noopener noreferrer"
         *     href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7741&isNormal=1&vid=270">查询实例的逻辑拓扑</a>
         *     AccessNode表proxyName字段
         * <li>其他实例类型传入Redis节点名称<br>
         *     可调用 <a target="_blank" rel="noopener noreferrer"
         *     href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7752&isNormal=1&vid=270">获取redis节点名列表</a>
         *     node表nodeName字段
         */
        @JsonProperty("nodeName")
        private String nodeName;

        /** 开始时间，允许值范围14天内 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间，允许值范围14天内 */
        @JsonProperty("endTime")
        private String endTime;

        /** 页码，默认1。 */
        @JsonProperty("page")
        private Integer page;

        /** 每页行数，默认10，允许值范围1~100。 */
        @JsonProperty("rows")
        private Integer rows;

        /** 最小持续时间，单位微秒，允许值范围0~999999999。 */
        @JsonProperty("minCost")
        private Integer minCost;

        /** 最大持续时间，单位微秒，允许值范围0~999999999。 */
        @JsonProperty("maxCost")
        private Integer maxCost;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getRows() {
            return this.rows;
        }

        public void setRows(Integer rows) {
            this.rows = rows;
        }

        public Integer getMinCost() {
            return this.minCost;
        }

        public void setMinCost(Integer minCost) {
            this.minCost = minCost;
        }

        public Integer getMaxCost() {
            return this.maxCost;
        }

        public void setMaxCost(Integer maxCost) {
            this.maxCost = maxCost;
        }
    }

    public static class FindHistorySlowLogResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private FindHistorySlowLogReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public FindHistorySlowLogReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(FindHistorySlowLogReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class FindHistorySlowLogReturnObjResponse {
        /** 数量。 */
        @JsonProperty("total")
        private Integer total;

        /** 慢日志对象列表。 */
        @JsonProperty("rows")
        private List<FindHistorySlowLogReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<FindHistorySlowLogReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<FindHistorySlowLogReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class FindHistorySlowLogReturnObjRowsResponse {
        /** 日志ID。 */
        @JsonProperty("id")
        private String id;

        /** 开始时间。 */
        @JsonProperty("beginTime")
        private String beginTime;

        /** 消耗时间ms。 */
        @JsonProperty("cost")
        private String cost;

        /** 命令、参数。 */
        @JsonProperty("command")
        private String command;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(String beginTime) {
            this.beginTime = beginTime;
        }

        public String getCost() {
            return this.cost;
        }

        public void setCost(String cost) {
            this.cost = cost;
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }
    }
}
