package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 按时间段查询分布式缓存Redis实例的历史大key、热key记录。 */
public class Dcs2FindHistoryBigAndHotKeyApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2FindHistoryBigAndHotKeyApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/resourceMonitor/findHistoryBigAndHotKey", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public FindHistoryBigAndHotKeyResponse send(
            Credential credential, FindHistoryBigAndHotKeyRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", request.startTime);
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        if (request.nodeName != null) {
            ctReq.addParam("nodeName", request.nodeName);
            request.nodeName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(FindHistoryBigAndHotKeyResponse.class);
    }

    public static class FindHistoryBigAndHotKeyRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 开始时间。 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间。 */
        @JsonProperty("endTime")
        private String endTime;

        /**
         * 节点名称，可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7752&isNormal=1&vid=270">获取redis节点名列表</a>
         * 接口，使用node表nodeName字段。
         */
        @JsonProperty("nodeName")
        private String nodeName;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }
    }

    public static class FindHistoryBigAndHotKeyResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private FindHistoryBigAndHotKeyReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public FindHistoryBigAndHotKeyReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(FindHistoryBigAndHotKeyReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class FindHistoryBigAndHotKeyReturnObjResponse {
        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("userName")
        private String userName;

        /** 数据采集时间戳（毫秒）。 */
        @JsonProperty("collectTime")
        private Long collectTime;

        /** 大key节点列表。 */
        @JsonProperty("bigKeyNode")
        private List<FindHistoryBigAndHotKeyReturnObjBigKeyNodeResponse> bigKeyNode;

        /** 热key节点列表。 */
        @JsonProperty("hotKeyNode")
        private List<FindHistoryBigAndHotKeyReturnObjHotKeyNodeResponse> hotKeyNode;

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public Long getCollectTime() {
            return this.collectTime;
        }

        public void setCollectTime(Long collectTime) {
            this.collectTime = collectTime;
        }

        public List<FindHistoryBigAndHotKeyReturnObjBigKeyNodeResponse> getBigKeyNode() {
            return this.bigKeyNode;
        }

        public void setBigKeyNode(
                List<FindHistoryBigAndHotKeyReturnObjBigKeyNodeResponse> bigKeyNode) {
            this.bigKeyNode = bigKeyNode;
        }

        public List<FindHistoryBigAndHotKeyReturnObjHotKeyNodeResponse> getHotKeyNode() {
            return this.hotKeyNode;
        }

        public void setHotKeyNode(
                List<FindHistoryBigAndHotKeyReturnObjHotKeyNodeResponse> hotKeyNode) {
            this.hotKeyNode = hotKeyNode;
        }
    }

    public static class FindHistoryBigAndHotKeyReturnObjBigKeyNodeResponse {
        /**
         * key类型标识
         * <li>bigKey：大key
         * <li>hotKey：热key
         */
        @JsonProperty("ID")
        private String iD;

        /** 元素个数 */
        @JsonProperty("size")
        private Integer size;

        /** key名 */
        @JsonProperty("key")
        private String key;

        /** key所在节点 */
        @JsonProperty("nodeUrl")
        private String nodeUrl;

        /** key所在分片 */
        @JsonProperty("db")
        private Integer db;

        public String getID() {
            return this.iD;
        }

        public void setID(String iD) {
            this.iD = iD;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getNodeUrl() {
            return this.nodeUrl;
        }

        public void setNodeUrl(String nodeUrl) {
            this.nodeUrl = nodeUrl;
        }

        public Integer getDb() {
            return this.db;
        }

        public void setDb(Integer db) {
            this.db = db;
        }
    }

    public static class FindHistoryBigAndHotKeyReturnObjHotKeyNodeResponse {
        /** hotKey */
        @JsonProperty("ID")
        private String iD;

        /** key类型 */
        @JsonProperty("keyType")
        private String keyType;

        /** 访问频次 */
        @JsonProperty("counter")
        private Integer counter;

        /** 请求次数 */
        @JsonProperty("queryCount")
        private String queryCount;

        /** key名 */
        @JsonProperty("key")
        private String key;

        /** key所在Redis节点 */
        @JsonProperty("nodeUrl")
        private String nodeUrl;

        /** key所在DB */
        @JsonProperty("db")
        private Integer db;

        public String getID() {
            return this.iD;
        }

        public void setID(String iD) {
            this.iD = iD;
        }

        public String getKeyType() {
            return this.keyType;
        }

        public void setKeyType(String keyType) {
            this.keyType = keyType;
        }

        public Integer getCounter() {
            return this.counter;
        }

        public void setCounter(Integer counter) {
            this.counter = counter;
        }

        public String getQueryCount() {
            return this.queryCount;
        }

        public void setQueryCount(String queryCount) {
            this.queryCount = queryCount;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getNodeUrl() {
            return this.nodeUrl;
        }

        public void setNodeUrl(String nodeUrl) {
            this.nodeUrl = nodeUrl;
        }

        public Integer getDb() {
            return this.db;
        }

        public void setDb(Integer db) {
            this.db = db;
        }
    }
}
