package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 修改自定义参数模板。 */
public class Dcs2EditRedisTemplateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2EditRedisTemplateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/redisTemplate/editRedisTemplate",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public EditRedisTemplateResponse send(Credential credential, EditRedisTemplateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(EditRedisTemplateResponse.class);
    }

    public static class EditRedisTemplateRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 模板。 */
        @JsonProperty("template")
        private EditRedisTemplateTemplateRequest template;

        /** 参数列表。 */
        @JsonProperty("params")
        private List<EditRedisTemplateParamsRequest> params;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public EditRedisTemplateTemplateRequest getTemplate() {
            return this.template;
        }

        public void setTemplate(EditRedisTemplateTemplateRequest template) {
            this.template = template;
        }

        public List<EditRedisTemplateParamsRequest> getParams() {
            return this.params;
        }

        public void setParams(List<EditRedisTemplateParamsRequest> params) {
            this.params = params;
        }
    }

    public static class EditRedisTemplateTemplateRequest {
        /**
         * 参数记录ID。 可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=15104&data=81&isNormal=1&vid=270">查询参数模板列表</a>
         * 接口，使用Template表id字段。
         */
        @JsonProperty("id")
        private String id;

        /** 参数名称。 */
        @JsonProperty("name")
        private String name;

        /** 参数描述。 */
        @JsonProperty("description")
        private String description;

        /**
         * 适合的实例架构版本，可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=15104&isNormal=1&vid=270">查询参数模板列表</a>
         * 接口，使用Template表cacheMode字段。
         */
        @JsonProperty("cacheMode")
        private String cacheMode;

        /** 是否系统模板。 */
        @JsonProperty("sysTemplate")
        private Boolean sysTemplate;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCacheMode() {
            return this.cacheMode;
        }

        public void setCacheMode(String cacheMode) {
            this.cacheMode = cacheMode;
        }

        public Boolean getSysTemplate() {
            return this.sysTemplate;
        }

        public void setSysTemplate(Boolean sysTemplate) {
            this.sysTemplate = sysTemplate;
        }
    }

    public static class EditRedisTemplateParamsRequest {
        /** 参数名称。 */
        @JsonProperty("paramName")
        private String paramName;

        /**
         * 目标值。参数的取值范围可参考<a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=15097&isNormal=1&vid=270">查询实例配置参数</a>
         * 返回的param表valueRange字段。
         */
        @JsonProperty("currentValue")
        private String currentValue;

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(String currentValue) {
            this.currentValue = currentValue;
        }
    }

    public static class EditRedisTemplateResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 无返回数据，空对象。 */
        @JsonProperty("returnObj")
        private EditRedisTemplateReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public EditRedisTemplateReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(EditRedisTemplateReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class EditRedisTemplateReturnObjResponse {}
}
