package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 下载分布式缓存Redis实例运行日志。 */
public class Dcs2DownloadRedisRunLogApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DownloadRedisRunLogApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/logMgr/downloadRedisRunLog", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DownloadRedisRunLogResponse send(
            Credential credential, DownloadRedisRunLogRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.nodeName != null) {
            ctReq.addParam("nodeName", request.nodeName);
            request.nodeName = null;
        }
        if (request.logType != null) {
            ctReq.addParam("logType", request.logType);
            request.logType = null;
        }
        if (request.date != null) {
            ctReq.addParam("date", request.date);
            request.date = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DownloadRedisRunLogResponse.class);
    }

    public static class DownloadRedisRunLogRequest {
        /**
         * 资源池ID，可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口，使用resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 实例ID。 */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 节点名称，可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7752&isNormal=1&vid=270">获取redis节点名列表</a>
         * 接口，使用node表nodeName字段。
         */
        @JsonProperty("nodeName")
        private String nodeName;

        /**
         * 日志级别（仅云盘型缓存支持，默认INFO），可选值：
         * <li>INFO
         * <li>WARNING
         * <li>ERROR
         * <li>FATAL
         */
        @JsonProperty("logType")
        private String logType;

        /** 日期, 仅支持下载最近14天的日志。 */
        @JsonProperty("date")
        private String date;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getLogType() {
            return this.logType;
        }

        public void setLogType(String logType) {
            this.logType = logType;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }
    }

    public static class DownloadRedisRunLogResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DownloadRedisRunLogReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码描述。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DownloadRedisRunLogReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DownloadRedisRunLogReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DownloadRedisRunLogReturnObjResponse {
        /** 文件名。 */
        @JsonProperty("fileName")
        private String fileName;

        /** 下载链接。 */
        @JsonProperty("downloadUrl")
        private String downloadUrl;

        public String getFileName() {
            return this.fileName;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getDownloadUrl() {
            return this.downloadUrl;
        }

        public void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }
    }
}
