package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 磁盘夯死故障注入 */
public class Dcs2DiskHangFaultInjectApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DiskHangFaultInjectApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/inject/diskHangFaultInject",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DiskHangFaultInjectResponse send(
            Credential credential, DiskHangFaultInjectRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DiskHangFaultInjectResponse.class);
    }

    public static class DiskHangFaultInjectRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 目标故障节点列表。 */
        @JsonProperty("nodes")
        private List<DiskHangFaultInjectNodesRequest> nodes;

        /** 故障持续时间(秒), 最小值为60。 */
        @JsonProperty("duration")
        private Integer duration;

        /**
         * 故障动作类型。
         * <li>disk-freeze: 磁盘夯死。
         */
        @JsonProperty("actionCode")
        private String actionCode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public List<DiskHangFaultInjectNodesRequest> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<DiskHangFaultInjectNodesRequest> nodes) {
            this.nodes = nodes;
        }

        public Integer getDuration() {
            return this.duration;
        }

        public void setDuration(Integer duration) {
            this.duration = duration;
        }

        public String getActionCode() {
            return this.actionCode;
        }

        public void setActionCode(String actionCode) {
            this.actionCode = actionCode;
        }
    }

    public static class DiskHangFaultInjectNodesRequest {
        /**
         * 业务IP。可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7740&isNormal=1&vid=270">查询集群节点信息</a>
         * 使用RedisNode表nodeVpcIp字段。
         */
        @JsonProperty("vpcIp")
        private String vpcIp;

        public String getVpcIp() {
            return this.vpcIp;
        }

        public void setVpcIp(String vpcIp) {
            this.vpcIp = vpcIp;
        }
    }

    public static class DiskHangFaultInjectResponse {
        /** 响应状态码，取值范围：800 成功，900 失败 */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DiskHangFaultInjectReturnObjResponse returnObj;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DiskHangFaultInjectReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DiskHangFaultInjectReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DiskHangFaultInjectReturnObjResponse {
        /** 撤销故障任务ID，使用该任务ID查询撤销故障执行详情。 */
        @JsonProperty("taskId")
        private String taskId;

        /** 演练ID，故障注入与故障恢复一起构成完整的一次故障演练，使用该ID查询故障执行详情与执行撤销故障。 */
        @JsonProperty("experimentId")
        private String experimentId;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getExperimentId() {
            return this.experimentId;
        }

        public void setExperimentId(String experimentId) {
            this.experimentId = experimentId;
        }
    }
}
