package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询慢日志。 */
public class Dcs2DescribeTopSlowLogRecoredsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeTopSlowLogRecoredsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/logMgr/describeTopSlowLogRecords", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeTopSlowLogRecoredsResponse send(
            Credential credential, DescribeTopSlowLogRecoredsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.nodeName != null) {
            ctReq.addParam("nodeName", request.nodeName);
            request.nodeName = null;
        }
        if (request.size != null) {
            ctReq.addParam("size", String.valueOf(request.size));
            request.size = null;
        }
        if (request.minCost != null) {
            ctReq.addParam("minCost", String.valueOf(request.minCost));
            request.minCost = null;
        }
        if (request.maxCost != null) {
            ctReq.addParam("maxCost", String.valueOf(request.maxCost));
            request.maxCost = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeTopSlowLogRecoredsResponse.class);
    }

    public static class DescribeTopSlowLogRecoredsRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 节点名称（查询多个时，英文逗号拼接传输），可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7752&isNormal=1&vid=270">获取redis节点名列表</a>
         * 接口，使用node表nodeName字段。
         */
        @JsonProperty("nodeName")
        private String nodeName;

        /** 查询条数，允许值范围1~1024。 */
        @JsonProperty("size")
        private Integer size;

        /** 最小持续时间，单位微秒，允许值范围0~999999999。 */
        @JsonProperty("minCost")
        private Integer minCost;

        /** 最大持续时间，单位微秒，允许值范围0~999999999。 */
        @JsonProperty("maxCost")
        private Integer maxCost;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public Integer getMinCost() {
            return this.minCost;
        }

        public void setMinCost(Integer minCost) {
            this.minCost = minCost;
        }

        public Integer getMaxCost() {
            return this.maxCost;
        }

        public void setMaxCost(Integer maxCost) {
            this.maxCost = maxCost;
        }
    }

    public static class DescribeTopSlowLogRecoredsResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeTopSlowLogRecoredsReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeTopSlowLogRecoredsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeTopSlowLogRecoredsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeTopSlowLogRecoredsReturnObjResponse {
        /** 数量。 */
        @JsonProperty("total")
        private Integer total;

        /** 慢日志对象列表。 */
        @JsonProperty("rows")
        private List<DescribeTopSlowLogRecoredsReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<DescribeTopSlowLogRecoredsReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<DescribeTopSlowLogRecoredsReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class DescribeTopSlowLogRecoredsReturnObjRowsResponse {
        /** 日志ID。 */
        @JsonProperty("id")
        private String id;

        /** 开始时间,Unix时间戳格式。 */
        @JsonProperty("beginTime")
        private String beginTime;

        /** 消耗时间μs。 */
        @JsonProperty("cost")
        private String cost;

        /** 命令、参数。 */
        @JsonProperty("command")
        private String command;

        /** 客户端地址。 */
        @JsonProperty("clientUrl")
        private String clientUrl;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getBeginTime() {
            return this.beginTime;
        }

        public void setBeginTime(String beginTime) {
            this.beginTime = beginTime;
        }

        public String getCost() {
            return this.cost;
        }

        public void setCost(String cost) {
            this.cost = cost;
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }

        public String getClientUrl() {
            return this.clientUrl;
        }

        public void setClientUrl(String clientUrl) {
            this.clientUrl = clientUrl;
        }
    }
}
