package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询大key自动分析策略。 */
public class Dcs2DescribeTopBigKeysPolicyApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeTopBigKeysPolicyApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/keyAnalysisMgrServant/describeTopBigKeysPolicy",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeTopBigKeysPolicyResponse send(
            Credential credential, DescribeTopBigKeysPolicyRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeTopBigKeysPolicyResponse.class);
    }

    public static class DescribeTopBigKeysPolicyRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }

    public static class DescribeTopBigKeysPolicyResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private DescribeTopBigKeysPolicyReturnObjResponse returnObj;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public DescribeTopBigKeysPolicyReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeTopBigKeysPolicyReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeTopBigKeysPolicyReturnObjResponse {
        /**
         * 是否开启大key备份策略（某日某时刻触发）。
         * <li>true: 开启。
         * <li>false：关闭。
         */
        @JsonProperty("enable_auto_scanBigkey")
        private Boolean enable_auto_scanBigkey;

        /** 触发日期，1-7表示周一至周日，多个日期使用英文逗号分隔。 */
        @JsonProperty("schedule_days")
        private String schedule_days;

        /** 触发时间点，整点时刻。 */
        @JsonProperty("schedule_hours")
        private String schedule_hours;

        /**
         * 是否开启大key周期扫描任务（每半小时触发）。
         * <li>true: 开启。
         * <li>false：关闭。
         */
        @JsonProperty("enable_cycle_scanBigkey")
        private Boolean enable_cycle_scanBigkey;

        public Boolean getEnable_auto_scanBigkey() {
            return this.enable_auto_scanBigkey;
        }

        public void setEnable_auto_scanBigkey(Boolean enable_auto_scanBigkey) {
            this.enable_auto_scanBigkey = enable_auto_scanBigkey;
        }

        public String getSchedule_days() {
            return this.schedule_days;
        }

        public void setSchedule_days(String schedule_days) {
            this.schedule_days = schedule_days;
        }

        public String getSchedule_hours() {
            return this.schedule_hours;
        }

        public void setSchedule_hours(String schedule_hours) {
            this.schedule_hours = schedule_hours;
        }

        public Boolean getEnable_cycle_scanBigkey() {
            return this.enable_cycle_scanBigkey;
        }

        public void setEnable_cycle_scanBigkey(Boolean enable_cycle_scanBigkey) {
            this.enable_cycle_scanBigkey = enable_cycle_scanBigkey;
        }
    }
}
