package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 分页查询分布式缓存Redis实例运行日志。 */
public class Dcs2DescribeRunningLogRecordsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeRunningLogRecordsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/logMgr/describeRunningLogRecords", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeRunningLogRecordsResponse send(
            Credential credential, DescribeRunningLogRecordsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.nodeName != null) {
            ctReq.addParam("nodeName", request.nodeName);
            request.nodeName = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.pageIndex != null) {
            ctReq.addParam("pageIndex", String.valueOf(request.pageIndex));
            request.pageIndex = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeRunningLogRecordsResponse.class);
    }

    public static class DescribeRunningLogRecordsRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 节点名称，可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7752&isNormal=1&vid=270">获取redis节点名列表</a>
         * 接口，使用node表nodeName字段。
         */
        @JsonProperty("nodeName")
        private String nodeName;

        /** 每页大小，默认值为10。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 页码，默认值为1。 */
        @JsonProperty("pageIndex")
        private Integer pageIndex;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public Integer getPageIndex() {
            return this.pageIndex;
        }

        public void setPageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
        }
    }

    public static class DescribeRunningLogRecordsResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeRunningLogRecordsReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeRunningLogRecordsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeRunningLogRecordsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeRunningLogRecordsReturnObjResponse {
        /** rows。 */
        @JsonProperty("rows")
        private List<DescribeRunningLogRecordsReturnObjRowsResponse> rows;

        /** 数量。 */
        @JsonProperty("total")
        private Integer total;

        /** 当前页。 */
        @JsonProperty("currentPage")
        private Integer currentPage;

        public List<DescribeRunningLogRecordsReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<DescribeRunningLogRecordsReturnObjRowsResponse> rows) {
            this.rows = rows;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getCurrentPage() {
            return this.currentPage;
        }

        public void setCurrentPage(Integer currentPage) {
            this.currentPage = currentPage;
        }
    }

    public static class DescribeRunningLogRecordsReturnObjRowsResponse {
        /** 产生时间。 */
        @JsonProperty("genTime")
        private String genTime;

        /** 日志信息。 */
        @JsonProperty("logInfo")
        private String logInfo;

        public String getGenTime() {
            return this.genTime;
        }

        public void setGenTime(String genTime) {
            this.genTime = genTime;
        }

        public String getLogInfo() {
            return this.logInfo;
        }

        public void setLogInfo(String logInfo) {
            this.logInfo = logInfo;
        }
    }
}
