package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询参数模板详情。 */
public class Dcs2DescribeRedisTemplateDetailApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeRedisTemplateDetailApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/redisTemplate/describeRedisTemplateDetail", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeRedisTemplateDetailResponse send(
            Credential credential, DescribeRedisTemplateDetailRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.templateId != null) {
            ctReq.addParam("templateId", request.templateId);
            request.templateId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeRedisTemplateDetailResponse.class);
    }

    public static class DescribeRedisTemplateDetailRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 模板ID。 可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=15104&data=81&isNormal=1&vid=270">查询参数模板列表</a>
         * 接口，使用Template表id字段。
         */
        @JsonProperty("templateId")
        private String templateId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public void setTemplateId(String templateId) {
            this.templateId = templateId;
        }
    }

    public static class DescribeRedisTemplateDetailResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeRedisTemplateDetailReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeRedisTemplateDetailReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeRedisTemplateDetailReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeRedisTemplateDetailReturnObjResponse {
        /** 总数。 */
        @JsonProperty("template")
        private DescribeRedisTemplateDetailReturnObjTemplateResponse template;

        /** 参数数组。 */
        @JsonProperty("params")
        private List<DescribeRedisTemplateDetailReturnObjParamsResponse> params;

        public DescribeRedisTemplateDetailReturnObjTemplateResponse getTemplate() {
            return this.template;
        }

        public void setTemplate(DescribeRedisTemplateDetailReturnObjTemplateResponse template) {
            this.template = template;
        }

        public List<DescribeRedisTemplateDetailReturnObjParamsResponse> getParams() {
            return this.params;
        }

        public void setParams(List<DescribeRedisTemplateDetailReturnObjParamsResponse> params) {
            this.params = params;
        }
    }

    public static class DescribeRedisTemplateDetailReturnObjTemplateResponse {
        /** 参数记录ID。 */
        @JsonProperty("id")
        private String id;

        /** 参数名称。 */
        @JsonProperty("name")
        private String name;

        /** 参数描述。 */
        @JsonProperty("description")
        private String description;

        /**
         * 适合的实例架构版本。
         * <li>ORIGINAL_67：Redis 6.0/7.0类型。
         * <li>ORIGINAL_5：Redis 5.0类型。
         * <li>CLASSIC：经典版。
         */
        @JsonProperty("cacheMode")
        private String cacheMode;

        /**
         * 是否为系统模板。
         * <li>true：系统模板。
         * <li>false：自定义模板。
         */
        @JsonProperty("sysTemplate")
        private Boolean sysTemplate;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCacheMode() {
            return this.cacheMode;
        }

        public void setCacheMode(String cacheMode) {
            this.cacheMode = cacheMode;
        }

        public Boolean getSysTemplate() {
            return this.sysTemplate;
        }

        public void setSysTemplate(Boolean sysTemplate) {
            this.sysTemplate = sysTemplate;
        }
    }

    public static class DescribeRedisTemplateDetailReturnObjParamsResponse {
        /** 参数名称。 */
        @JsonProperty("paramName")
        private String paramName;

        /** 参数描述。 */
        @JsonProperty("description")
        private String description;

        /** 参数范围。 */
        @JsonProperty("valueRange")
        private String valueRange;

        /** 默认值。 */
        @JsonProperty("defaultValue")
        private String defaultValue;

        /**
         * 参数修改后是否需要重启实例。
         * <li>true：需要重启。
         * <li>false：无需重启。
         */
        @JsonProperty("needRestart")
        private Boolean needRestart;

        /** 当前值。 */
        @JsonProperty("currentValue")
        private String currentValue;

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getValueRange() {
            return this.valueRange;
        }

        public void setValueRange(String valueRange) {
            this.valueRange = valueRange;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Boolean getNeedRestart() {
            return this.needRestart;
        }

        public void setNeedRestart(Boolean needRestart) {
            this.needRestart = needRestart;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(String currentValue) {
            this.currentValue = currentValue;
        }
    }
}
