package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询可用的参数模版列表。 */
public class Dcs2DescribeRedisTemplateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeRedisTemplateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/redisTemplate/describeRedisTemplate", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeRedisTemplateResponse send(
            Credential credential, DescribeRedisTemplateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.type != null) {
            ctReq.addParam("type", request.type);
            request.type = null;
        }
        if (request.pageNum != null) {
            ctReq.addParam("pageNum", String.valueOf(request.pageNum));
            request.pageNum = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeRedisTemplateResponse.class);
    }

    public static class DescribeRedisTemplateRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 模板类型。
         * <li>sys：系统模板。
         * <li>custom：自定义模板。
         */
        @JsonProperty("type")
        private String type;

        /** 页码，默认1。 */
        @JsonProperty("pageNum")
        private Integer pageNum;

        /** 每页记录数，默认值：10。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getPageNum() {
            return this.pageNum;
        }

        public void setPageNum(Integer pageNum) {
            this.pageNum = pageNum;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class DescribeRedisTemplateResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeRedisTemplateReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeRedisTemplateReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeRedisTemplateReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeRedisTemplateReturnObjResponse {
        /** 总数。 */
        @JsonProperty("total")
        private Integer total;

        /** 本次返回数量。 */
        @JsonProperty("size")
        private Integer size;

        /** 参数对象列表。 */
        @JsonProperty("list")
        private List<DescribeRedisTemplateReturnObjListResponse> list;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public List<DescribeRedisTemplateReturnObjListResponse> getList() {
            return this.list;
        }

        public void setList(List<DescribeRedisTemplateReturnObjListResponse> list) {
            this.list = list;
        }
    }

    public static class DescribeRedisTemplateReturnObjListResponse {
        /** 参数记录ID。 */
        @JsonProperty("id")
        private String id;

        /** 参数名称。 */
        @JsonProperty("name")
        private String name;

        /** 参数描述。 */
        @JsonProperty("description")
        private String description;

        /**
         * 适合的实例架构版本。
         * <li>ORIGINAL_67：Redis 6.0/7.0类型。
         * <li>ORIGINAL_5：Redis 5.0类型。
         */
        @JsonProperty("cacheMode")
        private String cacheMode;

        /**
         * 是否为系统模板。
         * <li>true：系统模板。
         * <li>false：自定义模板。
         */
        @JsonProperty("sysTemplate")
        private Boolean sysTemplate;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getCacheMode() {
            return this.cacheMode;
        }

        public void setCacheMode(String cacheMode) {
            this.cacheMode = cacheMode;
        }

        public Boolean getSysTemplate() {
            return this.sysTemplate;
        }

        public void setSysTemplate(Boolean sysTemplate) {
            this.sysTemplate = sysTemplate;
        }
    }
}
