package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询创建分布式缓存Redis实例、续费或变更实例规格等操作产生的费用。 */
public class Dcs2DescribePriceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribePriceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/lifeCycleServant/describePrice",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribePriceResponse send(Credential credential, DescribePriceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribePriceResponse.class);
    }

    public static class DescribePriceRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。<br>
         * 说明：orderType为BUY无需填写，其他值必填。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 订单类型，可选值：<br>
         * <br>
         * <b>订购</b>
         * <li><strong>BUY</strong>：订购。<br>
         *     <br>
         *     <b>续订</b>
         * <li><strong>RENEW</strong>：续订，仅包周期付费实例可选。<br>
         *     <br>
         *     <b>架构变更</b>
         * <li><strong>UPGRADE</strong>：架构变更（说明：单机→主备，集群单机→集群主备时，内存容量不可变更）。<br>
         *     <b>纵向扩展</b>
         * <li><strong>EXPANSION</strong>：实例/分片规格扩容（适用：Single/Dual/StandardSingle/StandardDual/DirectClusterSingle/DirectCluster/ClusterOriginalProxy/OriginalMultipleReadLvs）。
         * <li><strong>CONTRACTION</strong>：实例/分片规格缩容（适用：同上）。<br>
         *     <br>
         *     <b>横向扩展</b>
         * <li><strong>INCREASE_SHARDS</strong>：增加集群分片（适用：DirectClusterSingle/DirectCluster/ClusterOriginalProxy）。
         * <li><strong>DECREASE_SHARDS</strong>：减少集群分片（适用：同上）。<br>
         *     <br>
         *     <b>副本调整</b>
         * <li><strong>INCREASE_REPLICAS</strong>：增加数据副本（适用：StandardDual/DirectCluster/ClusterOriginalProxy/OriginalMultipleReadLvs）。
         * <li><strong>DECREASE_REPLICAS</strong>：减少数据副本（适用：同上）。
         */
        @JsonProperty("orderType")
        private String orderType;

        /**
         * 计费模式。
         * <li>PrePaid：包年包月（需配合period使用）。
         * <li>PostPaid：按需计费(默认值)。
         */
        @JsonProperty("chargeType")
        private String chargeType;

        /** 订购时长(月)，仅当chargeType=PrePaid时必填，取值范围：1~6,12,24,36。 */
        @JsonProperty("period")
        private String period;

        /** 数量，仅在订购询价时填写。允许批量订购，允许范围1-100，默认1。 */
        @JsonProperty("size")
        private Integer size;

        /**
         * 版本类型，取值：
         * <li>BASIC（默认）：基础版。
         * <li>PLUS：增强版。
         * <li>Classic：经典版(白名单)。
         */
        @JsonProperty("version")
        private String version;

        /**
         * 实例类型，例如 StandardSingle 为单机版实例，详细信息请参见 <a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。
         */
        @JsonProperty("edition")
        private String edition;

        /**
         * Redis引擎版本，当orderType为BUY时必填。详细信息请参见 <a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。<br>
         * 当 version 取值为 BASIC时，版本号取值：
         * <li>5.0
         * <li>6.0（推荐）
         * <li>7.0<br>
         *     当 version 取值为 PLUS，版本号取值：
         * <li>6.0
         * <li>7.0<br>
         *     当 version 取值为 Classic时，版本号取值：
         * <li>2.8
         * <li>4.0
         * <li>5.0
         */
        @JsonProperty("engineVersion")
        private String engineVersion;

        /**
         * 主机类型，详细信息请参见 <a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。<br>
         * X86取值：
         * <li>S：通用型
         * <li>C：计算增强型
         * <li>M：内存型
         * <li>HS：海光通用型
         * <li>HC：海光计算增强型<br>
         *     ARM取值：
         * <li>KS：鲲鹏通用型
         * <li>KC：鲲鹏计算增强型<br>
         *     说明：当 version 取值为 Classic 时不可选，默认为S。
         */
        @JsonProperty("hostType")
        private String hostType;

        /**
         * 分片规格，单位为 GB，详细信息请参见 <a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。<br>
         * 当 version 取值为 BASIC，取值：
         * <li>1
         * <li>2
         * <li>4
         * <li>8
         * <li>16
         * <li>32
         * <li>64<br>
         *     当 version 取值为 PLUS时，取值：
         * <li>8
         * <li>16
         * <li>32
         * <li>64<br>
         *     其他版本无需填写此参数。
         */
        @JsonProperty("shardMemSize")
        private String shardMemSize;

        /**
         * 分片数，详细信息请参见 <a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a> ， 取值范围如下：
         * <li>当 edition 取值为 DirectClusterSingle/DirectCluster/ClusterOriginalProxy时: 3~256。
         * <li>当 edition 取其他值时无需填写。
         */
        @JsonProperty("shardCount")
        private Integer shardCount;

        /**
         * 实例的存储容量，单位为 GB，仅当version 取值为 Classic 时填写，详细信息请参见 <a target="_blank" rel="noopener
         * noreferrer" href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。
         */
        @JsonProperty("capacity")
        private String capacity;

        /**
         * 副本数，取值范围2~10，详细信息请参见 <a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。
         * <li>当 edition 取值为 OriginalMultipleReadLvs时必填。
         * <li>当 edition 取值为 StandardDual/DirectCluster/ClusterOriginalProxy时选填。<br>
         *     当 edition 取其他值时无需填写。
         */
        @JsonProperty("copiesCount")
        private Integer copiesCount;

        /**
         * 磁盘类型，详细信息请参见 <a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>，取值：
         * <li>SSD（默认）：超高IO。
         * <li>SAS：高IO。 <br>
         *     说明：当 version 取值为 Classic时不可选，默认为SAS。
         */
        @JsonProperty("dataDiskType")
        private String dataDiskType;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getOrderType() {
            return this.orderType;
        }

        public void setOrderType(String orderType) {
            this.orderType = orderType;
        }

        public String getChargeType() {
            return this.chargeType;
        }

        public void setChargeType(String chargeType) {
            this.chargeType = chargeType;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getEdition() {
            return this.edition;
        }

        public void setEdition(String edition) {
            this.edition = edition;
        }

        public String getEngineVersion() {
            return this.engineVersion;
        }

        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public String getShardMemSize() {
            return this.shardMemSize;
        }

        public void setShardMemSize(String shardMemSize) {
            this.shardMemSize = shardMemSize;
        }

        public Integer getShardCount() {
            return this.shardCount;
        }

        public void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        public String getCapacity() {
            return this.capacity;
        }

        public void setCapacity(String capacity) {
            this.capacity = capacity;
        }

        public Integer getCopiesCount() {
            return this.copiesCount;
        }

        public void setCopiesCount(Integer copiesCount) {
            this.copiesCount = copiesCount;
        }

        public String getDataDiskType() {
            return this.dataDiskType;
        }

        public void setDataDiskType(String dataDiskType) {
            this.dataDiskType = dataDiskType;
        }
    }

    public static class DescribePriceResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribePriceReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribePriceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribePriceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribePriceReturnObjResponse {
        /** 订单总价。 */
        @JsonProperty("totalPrice")
        private Double totalPrice;

        /** serviceTag。 */
        @JsonProperty("serviceTag")
        private String serviceTag;

        /** 订单最终价格。 */
        @JsonProperty("finalPrice")
        private Double finalPrice;

        /** 子订单价格。 */
        @JsonProperty("subOrderPrices")
        private List<DescribePriceReturnObjSubOrderPricesResponse> subOrderPrices;

        /** 状态校验。 */
        @JsonProperty("verifyStatusCode")
        private String verifyStatusCode;

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public String getServiceTag() {
            return this.serviceTag;
        }

        public void setServiceTag(String serviceTag) {
            this.serviceTag = serviceTag;
        }

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }

        public List<DescribePriceReturnObjSubOrderPricesResponse> getSubOrderPrices() {
            return this.subOrderPrices;
        }

        public void setSubOrderPrices(
                List<DescribePriceReturnObjSubOrderPricesResponse> subOrderPrices) {
            this.subOrderPrices = subOrderPrices;
        }

        public String getVerifyStatusCode() {
            return this.verifyStatusCode;
        }

        public void setVerifyStatusCode(String verifyStatusCode) {
            this.verifyStatusCode = verifyStatusCode;
        }
    }

    public static class DescribePriceReturnObjSubOrderPricesResponse {
        /** 子订单总价。 */
        @JsonProperty("totalPrice")
        private Double totalPrice;

        /** serviceTag。 */
        @JsonProperty("serviceTag")
        private String serviceTag;

        /** 子订单最终价格。 */
        @JsonProperty("finalPrice")
        private Double finalPrice;

        /** 子订单价格明细。 */
        @JsonProperty("orderItemPrices")
        private List<DescribePriceReturnObjSubOrderPricesOrderItemPricesResponse> orderItemPrices;

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public String getServiceTag() {
            return this.serviceTag;
        }

        public void setServiceTag(String serviceTag) {
            this.serviceTag = serviceTag;
        }

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }

        public List<DescribePriceReturnObjSubOrderPricesOrderItemPricesResponse>
                getOrderItemPrices() {
            return this.orderItemPrices;
        }

        public void setOrderItemPrices(
                List<DescribePriceReturnObjSubOrderPricesOrderItemPricesResponse> orderItemPrices) {
            this.orderItemPrices = orderItemPrices;
        }
    }

    public static class DescribePriceReturnObjSubOrderPricesOrderItemPricesResponse {
        /** 子订单资源ID。 */
        @JsonProperty("itemId")
        private String itemId;

        /** 子订单资源总价。 */
        @JsonProperty("totalPrice")
        private Double totalPrice;

        /** 子订单资源最终价格。 */
        @JsonProperty("finalPrice")
        private Double finalPrice;

        /** 子订单资源类型。 */
        @JsonProperty("resourceType")
        private String resourceType;

        public String getItemId() {
            return this.itemId;
        }

        public void setItemId(String itemId) {
            this.itemId = itemId;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }

        public Double getFinalPrice() {
            return this.finalPrice;
        }

        public void setFinalPrice(Double finalPrice) {
            this.finalPrice = finalPrice;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }
    }
}
