package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查看分布式缓存Redis实例配置参数修改历史记录。 */
public class Dcs2DescribeParameterModificationHistoryApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeParameterModificationHistoryApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/instanceParam/describeParameterModificationHistory",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeParameterModificationHistoryResponse send(
            Credential credential, DescribeParameterModificationHistoryRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", request.startTime);
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        if (request.historyId != null) {
            ctReq.addParam("historyId", request.historyId);
            request.historyId = null;
        }
        if (request.page != null) {
            ctReq.addParam("page", String.valueOf(request.page));
            request.page = null;
        }
        if (request.rows != null) {
            ctReq.addParam("rows", String.valueOf(request.rows));
            request.rows = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeParameterModificationHistoryResponse.class);
    }

    public static class DescribeParameterModificationHistoryRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 开始时间。 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间。 */
        @JsonProperty("endTime")
        private String endTime;

        /**
         * 记录ID。支持查询所有和单个记录。默认查询所有，若historyId入参不为空，则查询单个记录。<br>
         * 说明：若historyId为空，则需要传入startTime、endTime, 按时间查询所有记录。
         */
        @JsonProperty("historyId")
        private String historyId;

        /** 页码。 */
        @JsonProperty("page")
        private Integer page;

        /** 行数。 */
        @JsonProperty("rows")
        private Integer rows;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public String getHistoryId() {
            return this.historyId;
        }

        public void setHistoryId(String historyId) {
            this.historyId = historyId;
        }

        public Integer getPage() {
            return this.page;
        }

        public void setPage(Integer page) {
            this.page = page;
        }

        public Integer getRows() {
            return this.rows;
        }

        public void setRows(Integer rows) {
            this.rows = rows;
        }
    }

    public static class DescribeParameterModificationHistoryResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeParameterModificationHistoryReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeParameterModificationHistoryReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeParameterModificationHistoryReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeParameterModificationHistoryReturnObjResponse {
        /** 数量。 */
        @JsonProperty("total")
        private Integer total;

        /** 参数对象。 */
        @JsonProperty("rows")
        private List<DescribeParameterModificationHistoryReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<DescribeParameterModificationHistoryReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<DescribeParameterModificationHistoryReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class DescribeParameterModificationHistoryReturnObjRowsResponse {
        /** 历史记录。 */
        @JsonProperty("history")
        private DescribeParameterModificationHistoryReturnObjRowsHistoryResponse history;

        /** 参数记录。 */
        @JsonProperty("params")
        private List<DescribeParameterModificationHistoryReturnObjRowsParamsResponse> params;

        /** 记录数。 */
        @JsonProperty("size")
        private Integer size;

        public DescribeParameterModificationHistoryReturnObjRowsHistoryResponse getHistory() {
            return this.history;
        }

        public void setHistory(
                DescribeParameterModificationHistoryReturnObjRowsHistoryResponse history) {
            this.history = history;
        }

        public List<DescribeParameterModificationHistoryReturnObjRowsParamsResponse> getParams() {
            return this.params;
        }

        public void setParams(
                List<DescribeParameterModificationHistoryReturnObjRowsParamsResponse> params) {
            this.params = params;
        }

        public Integer getSize() {
            return this.size;
        }

        public void setSize(Integer size) {
            this.size = size;
        }
    }

    public static class DescribeParameterModificationHistoryReturnObjRowsHistoryResponse {
        /** 历史记录ID。 */
        @JsonProperty("historyId")
        private String historyId;

        /** 类型。 */
        @JsonProperty("type")
        private String type;

        /** 创建时间。 */
        @JsonProperty("createdAt")
        private String createdAt;

        /**
         * 状态。
         * <li>SUCCESS：成功。
         * <li>FAILED：失败。
         */
        @JsonProperty("status")
        private String status;

        public String getHistoryId() {
            return this.historyId;
        }

        public void setHistoryId(String historyId) {
            this.historyId = historyId;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getCreatedAt() {
            return this.createdAt;
        }

        public void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }

    public static class DescribeParameterModificationHistoryReturnObjRowsParamsResponse {
        /** 参数名称。 */
        @JsonProperty("paramName")
        private String paramName;

        /** 旧值。 */
        @JsonProperty("originalValue")
        private String originalValue;

        /** 当前值。 */
        @JsonProperty("currentValue")
        private String currentValue;

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public String getOriginalValue() {
            return this.originalValue;
        }

        public void setOriginalValue(String originalValue) {
            this.originalValue = originalValue;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(String currentValue) {
            this.currentValue = currentValue;
        }
    }
}
