package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询分布式缓存Redis实例离线全量key分析报告详情。 */
public class Dcs2DescribeOffLineKeyAnalysisTaskInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeOffLineKeyAnalysisTaskInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/keyAnalysisMgrServant/describeOffLineKeyAnalysisTaskInfo",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeOffLineKeyAnalysisTaskInfoResponse send(
            Credential credential, DescribeOffLineKeyAnalysisTaskInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.taskId != null) {
            ctReq.addParam("taskId", request.taskId);
            request.taskId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeOffLineKeyAnalysisTaskInfoResponse.class);
    }

    public static class DescribeOffLineKeyAnalysisTaskInfoRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }

    public static class DescribeOffLineKeyAnalysisTaskInfoResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeOffLineKeyAnalysisTaskInfoReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeOffLineKeyAnalysisTaskInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeOffLineKeyAnalysisTaskInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeOffLineKeyAnalysisTaskInfoReturnObjResponse {
        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        /**
         * RDB文件类型。
         * <li>0：上一个备份文件。
         * <li>1：新建备份文件。
         * <li>2：历史备份文件。
         */
        @JsonProperty("rdbtype")
        private String rdbtype;

        /** 已使用内存。 */
        @JsonProperty("usedMemory")
        private Long usedMemory;

        /** 总内存。 */
        @JsonProperty("maxmemory")
        private Long maxmemory;

        /** 已使用内存比例%。 */
        @JsonProperty("usedMemoryPercentage")
        private Double usedMemoryPercentage;

        /** 总key数量。 */
        @JsonProperty("totalkeys")
        private Long totalkeys;

        /** 设置过期key总数量。 */
        @JsonProperty("total_set_expirekeys")
        private Long total_set_expirekeys;

        /** 设置过期key的比例。 */
        @JsonProperty("total_set_expirekeysPercentage")
        private Double total_set_expirekeysPercentage;

        /** 已过期key数量。 */
        @JsonProperty("expiredKeys")
        private Long expiredKeys;

        /** 已逐出key数量。 */
        @JsonProperty("evictedKeys")
        private Long evictedKeys;

        /** 开始时间。 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间。 */
        @JsonProperty("endTime")
        private String endTime;

        /** 该对象返回格式随key类型变化。 */
        @JsonProperty("rdbinfo")
        private DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoResponse rdbinfo;

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public String getRdbtype() {
            return this.rdbtype;
        }

        public void setRdbtype(String rdbtype) {
            this.rdbtype = rdbtype;
        }

        public Long getUsedMemory() {
            return this.usedMemory;
        }

        public void setUsedMemory(Long usedMemory) {
            this.usedMemory = usedMemory;
        }

        public Long getMaxmemory() {
            return this.maxmemory;
        }

        public void setMaxmemory(Long maxmemory) {
            this.maxmemory = maxmemory;
        }

        public Double getUsedMemoryPercentage() {
            return this.usedMemoryPercentage;
        }

        public void setUsedMemoryPercentage(Double usedMemoryPercentage) {
            this.usedMemoryPercentage = usedMemoryPercentage;
        }

        public Long getTotalkeys() {
            return this.totalkeys;
        }

        public void setTotalkeys(Long totalkeys) {
            this.totalkeys = totalkeys;
        }

        public Long getTotal_set_expirekeys() {
            return this.total_set_expirekeys;
        }

        public void setTotal_set_expirekeys(Long total_set_expirekeys) {
            this.total_set_expirekeys = total_set_expirekeys;
        }

        public Double getTotal_set_expirekeysPercentage() {
            return this.total_set_expirekeysPercentage;
        }

        public void setTotal_set_expirekeysPercentage(Double total_set_expirekeysPercentage) {
            this.total_set_expirekeysPercentage = total_set_expirekeysPercentage;
        }

        public Long getExpiredKeys() {
            return this.expiredKeys;
        }

        public void setExpiredKeys(Long expiredKeys) {
            this.expiredKeys = expiredKeys;
        }

        public Long getEvictedKeys() {
            return this.evictedKeys;
        }

        public void setEvictedKeys(Long evictedKeys) {
            this.evictedKeys = evictedKeys;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoResponse getRdbinfo() {
            return this.rdbinfo;
        }

        public void setRdbinfo(DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoResponse rdbinfo) {
            this.rdbinfo = rdbinfo;
        }
    }

    public static class DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoResponse {
        /** 最大key占用。 */
        @JsonProperty("LargestKeyPrefixes")
        private DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLargestKeyPrefixesResponse
                largestKeyPrefixes;

        /** 类型直接占用大小，格式为（键类型:占用大小）。 */
        @JsonProperty("TypeBytes")
        private DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoTypeBytesResponse typeBytes;

        /** key类型数量大小。 */
        @JsonProperty("TypeNum")
        private DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoTypeNumResponse typeNum;

        /** 当前实例文件。 */
        @JsonProperty("CurrentInstance")
        private String currentInstance;

        /** 最大的100个key列表。 */
        @JsonProperty("LargestKeys")
        private List<DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLargestKeysResponse>
                largestKeys;

        /** 总字节数。 */
        @JsonProperty("TotleBytes")
        private Long totleBytes;

        /** key总数。 */
        @JsonProperty("TotleNum")
        private Long totleNum;

        /** 不同数据结构的键长度分布情况。 */
        @JsonProperty("LenLevelCount")
        private DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLenLevelCountResponse
                lenLevelCount;

        public DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLargestKeyPrefixesResponse
                getLargestKeyPrefixes() {
            return this.largestKeyPrefixes;
        }

        public void setLargestKeyPrefixes(
                DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLargestKeyPrefixesResponse
                        largestKeyPrefixes) {
            this.largestKeyPrefixes = largestKeyPrefixes;
        }

        public DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoTypeBytesResponse getTypeBytes() {
            return this.typeBytes;
        }

        public void setTypeBytes(
                DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoTypeBytesResponse typeBytes) {
            this.typeBytes = typeBytes;
        }

        public DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoTypeNumResponse getTypeNum() {
            return this.typeNum;
        }

        public void setTypeNum(
                DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoTypeNumResponse typeNum) {
            this.typeNum = typeNum;
        }

        public String getCurrentInstance() {
            return this.currentInstance;
        }

        public void setCurrentInstance(String currentInstance) {
            this.currentInstance = currentInstance;
        }

        public List<DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLargestKeysResponse>
                getLargestKeys() {
            return this.largestKeys;
        }

        public void setLargestKeys(
                List<DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLargestKeysResponse>
                        largestKeys) {
            this.largestKeys = largestKeys;
        }

        public Long getTotleBytes() {
            return this.totleBytes;
        }

        public void setTotleBytes(Long totleBytes) {
            this.totleBytes = totleBytes;
        }

        public Long getTotleNum() {
            return this.totleNum;
        }

        public void setTotleNum(Long totleNum) {
            this.totleNum = totleNum;
        }

        public DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLenLevelCountResponse
                getLenLevelCount() {
            return this.lenLevelCount;
        }

        public void setLenLevelCount(
                DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLenLevelCountResponse
                        lenLevelCount) {
            this.lenLevelCount = lenLevelCount;
        }
    }

    public static
    class DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLargestKeyPrefixesResponse {
        /** 字节。 */
        @JsonProperty("Bytes")
        private Long bytes;

        /** key类型。 */
        @JsonProperty("Type")
        private String type;

        /** 数量。 */
        @JsonProperty("Num")
        private Long num;

        /** 前缀。 */
        @JsonProperty("Key")
        private String key;

        public Long getBytes() {
            return this.bytes;
        }

        public void setBytes(Long bytes) {
            this.bytes = bytes;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Long getNum() {
            return this.num;
        }

        public void setNum(Long num) {
            this.num = num;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }

    public static class DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoTypeBytesResponse {}

    public static class DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoTypeNumResponse {}

    public static class DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLargestKeysResponse {
        /** 字节。 */
        @JsonProperty("Bytes")
        private Long bytes;

        /** key类型。 */
        @JsonProperty("Type")
        private String type;

        /** 最大长度字段。 */
        @JsonProperty("FieldOfLargestElem")
        private String fieldOfLargestElem;

        /** 元素个数/长度。 */
        @JsonProperty("NumOfElem")
        private Long numOfElem;

        /** 最大元素长度。 */
        @JsonProperty("LenOfLargestElem")
        private Long lenOfLargestElem;

        /** 键名。 */
        @JsonProperty("Key")
        private String key;

        public Long getBytes() {
            return this.bytes;
        }

        public void setBytes(Long bytes) {
            this.bytes = bytes;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getFieldOfLargestElem() {
            return this.fieldOfLargestElem;
        }

        public void setFieldOfLargestElem(String fieldOfLargestElem) {
            this.fieldOfLargestElem = fieldOfLargestElem;
        }

        public Long getNumOfElem() {
            return this.numOfElem;
        }

        public void setNumOfElem(Long numOfElem) {
            this.numOfElem = numOfElem;
        }

        public Long getLenOfLargestElem() {
            return this.lenOfLargestElem;
        }

        public void setLenOfLargestElem(Long lenOfLargestElem) {
            this.lenOfLargestElem = lenOfLargestElem;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }
    }

    public static class DescribeOffLineKeyAnalysisTaskInfoReturnObjRdbinfoLenLevelCountResponse {}
}
