package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询节点状态。 */
public class Dcs2DescribeNodeRunningStateApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeNodeRunningStateApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/redisMgr/describeNodeRunningState", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeNodeRunningStateResponse send(
            Credential credential, DescribeNodeRunningStateRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.nodeType != null) {
            ctReq.addParam("nodeType", request.nodeType);
            request.nodeType = null;
        }
        if (request.vpcUrl != null) {
            ctReq.addParam("vpcUrl", request.vpcUrl);
            request.vpcUrl = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeNodeRunningStateResponse.class);
    }

    public static class DescribeNodeRunningStateRequest {
        /**
         * 资源池ID，可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 使用resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 节点类型，可选值:
         * <li>redis
         * <li>proxy<br>
         *     说明：<br>
         *     nodeType传入redis，查询Redis节点状态。<br>
         *     nodeType传入proxy，查询Proxy节点状态（仅Proxy集群/读写分离/经典集群版实例支持）。
         */
        @JsonProperty("nodeType")
        private String nodeType;

        /**
         * 节点地址。 可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7741&isNormal=1&vid=270">查询实例的逻辑拓扑</a>接口查询，如果nodeType传入redis则使用表RedisNode/SlaveNode的vpcUrl字段。如果nodeType传入proxy则使用表AccessNode的vpcUrl字段。
         */
        @JsonProperty("vpcUrl")
        private String vpcUrl;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public String getVpcUrl() {
            return this.vpcUrl;
        }

        public void setVpcUrl(String vpcUrl) {
            this.vpcUrl = vpcUrl;
        }
    }

    public static class DescribeNodeRunningStateResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private DescribeNodeRunningStateReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeNodeRunningStateReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeNodeRunningStateReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeNodeRunningStateReturnObjResponse {
        /**
         * 节点状态。
         * <li>0：运行中。
         * <li>1：停止。
         */
        @JsonProperty("status")
        private Integer status;

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }
    }
}
