package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;
import java.util.Map;

/** 查询分布式缓存Redis实例的节点监控指标历史数据。 */
public class Dcs2DescribeNodeHistoryMonitorValuesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeNodeHistoryMonitorValuesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/resourceMonitor/describeNodeHistoryMonitorValues",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeNodeHistoryMonitorValuesResponse send(
            Credential credential, DescribeNodeHistoryMonitorValuesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.nodeName != null) {
            ctReq.addParam("nodeName", request.nodeName);
            request.nodeName = null;
        }
        if (request.startTime != null) {
            ctReq.addParam("startTime", request.startTime);
            request.startTime = null;
        }
        if (request.endTime != null) {
            ctReq.addParam("endTime", request.endTime);
            request.endTime = null;
        }
        if (request.type != null) {
            ctReq.addParam("type", request.type);
            request.type = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeNodeHistoryMonitorValuesResponse.class);
    }

    public static class DescribeNodeHistoryMonitorValuesRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 节点名称，可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7752&isNormal=1&vid=270">获取redis节点名列表</a>
         * 接口，使用Node表nodeName字段。
         */
        @JsonProperty("nodeName")
        private String nodeName;

        /** 开始时间（格式：yyyy-MM-dd HH:mm:ss）。 */
        @JsonProperty("startTime")
        private String startTime;

        /** 结束时间（格式：yyyy-MM-dd HH:mm:ss）。 */
        @JsonProperty("endTime")
        private String endTime;

        /**
         * 节点监控类型，可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=15090&isNormal=1&vid=270">查询性能监控指标列表</a>
         * 接口，使用nodeMonitorList列表type字段。
         */
        @JsonProperty("type")
        private String type;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getStartTime() {
            return this.startTime;
        }

        public void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        public String getEndTime() {
            return this.endTime;
        }

        public void setEndTime(String endTime) {
            this.endTime = endTime;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static class DescribeNodeHistoryMonitorValuesResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeNodeHistoryMonitorValuesReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeNodeHistoryMonitorValuesReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeNodeHistoryMonitorValuesReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeNodeHistoryMonitorValuesReturnObjResponse {
        /** 数量。 */
        @JsonProperty("total")
        private Integer total;

        /** 监控数据列表。 */
        @JsonProperty("rows")
        private List<DescribeNodeHistoryMonitorValuesReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<DescribeNodeHistoryMonitorValuesReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<DescribeNodeHistoryMonitorValuesReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class DescribeNodeHistoryMonitorValuesReturnObjRowsResponse {
        /** 指标标签。标签内容以实际返回为准。 */
        @JsonProperty("metric")
        private Map<String, String> metric;

        /** 键值对数组。 */
        @JsonProperty("values")
        private List<DescribeNodeHistoryMonitorValuesReturnObjRowsValuesResponse> values;

        public Map<String, String> getMetric() {
            return this.metric;
        }

        public void setMetric(Map<String, String> metric) {
            this.metric = metric;
        }

        public List<DescribeNodeHistoryMonitorValuesReturnObjRowsValuesResponse> getValues() {
            return this.values;
        }

        public void setValues(
                List<DescribeNodeHistoryMonitorValuesReturnObjRowsValuesResponse> values) {
            this.values = values;
        }
    }

    public static class DescribeNodeHistoryMonitorValuesReturnObjRowsValuesResponse {
        /** 时间戳、值字符串数组。 */
        @JsonProperty("value")
        private List<String> value;

        public List<String> getValue() {
            return this.value;
        }

        public void setValue(List<String> value) {
            this.value = value;
        }
    }
}
