package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 查询分布式缓存Redis实例的逻辑拓扑结构。 */
public class Dcs2DescribeLogicInstanceTopologyApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeLogicInstanceTopologyApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/instanceManageMgrServant/describeLogicInstanceTopology",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeLogicInstanceTopologyResponse send(
            Credential credential, DescribeLogicInstanceTopologyRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeLogicInstanceTopologyResponse.class);
    }

    public static class DescribeLogicInstanceTopologyRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }

    public static class DescribeLogicInstanceTopologyResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeLogicInstanceTopologyReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeLogicInstanceTopologyReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeLogicInstanceTopologyReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeLogicInstanceTopologyReturnObjResponse {
        /** redis节点集合，见RedisNode。 */
        @JsonProperty("redisNodes")
        private List<DescribeLogicInstanceTopologyReturnObjRedisNodesResponse> redisNodes;

        /** 接入机节点集合，见AccessNode。 */
        @JsonProperty("accessNodes")
        private List<DescribeLogicInstanceTopologyReturnObjAccessNodesResponse> accessNodes;

        public List<DescribeLogicInstanceTopologyReturnObjRedisNodesResponse> getRedisNodes() {
            return this.redisNodes;
        }

        public void setRedisNodes(
                List<DescribeLogicInstanceTopologyReturnObjRedisNodesResponse> redisNodes) {
            this.redisNodes = redisNodes;
        }

        public List<DescribeLogicInstanceTopologyReturnObjAccessNodesResponse> getAccessNodes() {
            return this.accessNodes;
        }

        public void setAccessNodes(
                List<DescribeLogicInstanceTopologyReturnObjAccessNodesResponse> accessNodes) {
            this.accessNodes = accessNodes;
        }
    }

    public static class DescribeLogicInstanceTopologyReturnObjRedisNodesResponse {
        /** 连接地址。 */
        @JsonProperty("connUrl")
        private String connUrl;

        /** 开始槽位。 */
        @JsonProperty("startSlot")
        private String startSlot;

        /** 结束槽位。 */
        @JsonProperty("endSlot")
        private String endSlot;

        /** vpc连接地址。 */
        @JsonProperty("vpcUrl")
        private String vpcUrl;

        /**
         * 节点状态。
         * <li>CACHE.COMM.STATUS：正常。
         * <li>CACHE.DIAT.PREP：扩容数据准备。
         * <li>CACHE.DIAT.PROCESS：执行扩容数据。
         * <li>CACHE.DIAT.DEL：删除。
         * <li>CACHE.PROB.SWIT：故障待切换。
         */
        @JsonProperty("status")
        private String status;

        /** 主节点名称。 */
        @JsonProperty("masterName")
        private String masterName;

        /** 从节点集合，见SlaveNode。 */
        @JsonProperty("slaves")
        private List<DescribeLogicInstanceTopologyReturnObjRedisNodesSlavesResponse> slaves;

        public String getConnUrl() {
            return this.connUrl;
        }

        public void setConnUrl(String connUrl) {
            this.connUrl = connUrl;
        }

        public String getStartSlot() {
            return this.startSlot;
        }

        public void setStartSlot(String startSlot) {
            this.startSlot = startSlot;
        }

        public String getEndSlot() {
            return this.endSlot;
        }

        public void setEndSlot(String endSlot) {
            this.endSlot = endSlot;
        }

        public String getVpcUrl() {
            return this.vpcUrl;
        }

        public void setVpcUrl(String vpcUrl) {
            this.vpcUrl = vpcUrl;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getMasterName() {
            return this.masterName;
        }

        public void setMasterName(String masterName) {
            this.masterName = masterName;
        }

        public List<DescribeLogicInstanceTopologyReturnObjRedisNodesSlavesResponse> getSlaves() {
            return this.slaves;
        }

        public void setSlaves(
                List<DescribeLogicInstanceTopologyReturnObjRedisNodesSlavesResponse> slaves) {
            this.slaves = slaves;
        }
    }

    public static class DescribeLogicInstanceTopologyReturnObjAccessNodesResponse {
        /** 客户端连接数。 */
        @JsonProperty("clientConnNum")
        private Integer clientConnNum;

        /** 接入机最大并发连接数。 */
        @JsonProperty("clientMaxConnNum")
        private Integer clientMaxConnNum;

        /** Redis节点每秒连接数。 */
        @JsonProperty("connNumPerRedis")
        private String connNumPerRedis;

        /** 连接地址。 */
        @JsonProperty("connUrl")
        private String connUrl;

        /** 代理名称。 */
        @JsonProperty("proxyName")
        private String proxyName;

        /** vpc连接地址。 */
        @JsonProperty("vpcUrl")
        private String vpcUrl;

        public Integer getClientConnNum() {
            return this.clientConnNum;
        }

        public void setClientConnNum(Integer clientConnNum) {
            this.clientConnNum = clientConnNum;
        }

        public Integer getClientMaxConnNum() {
            return this.clientMaxConnNum;
        }

        public void setClientMaxConnNum(Integer clientMaxConnNum) {
            this.clientMaxConnNum = clientMaxConnNum;
        }

        public String getConnNumPerRedis() {
            return this.connNumPerRedis;
        }

        public void setConnNumPerRedis(String connNumPerRedis) {
            this.connNumPerRedis = connNumPerRedis;
        }

        public String getConnUrl() {
            return this.connUrl;
        }

        public void setConnUrl(String connUrl) {
            this.connUrl = connUrl;
        }

        public String getProxyName() {
            return this.proxyName;
        }

        public void setProxyName(String proxyName) {
            this.proxyName = proxyName;
        }

        public String getVpcUrl() {
            return this.vpcUrl;
        }

        public void setVpcUrl(String vpcUrl) {
            this.vpcUrl = vpcUrl;
        }
    }

    public static class DescribeLogicInstanceTopologyReturnObjRedisNodesSlavesResponse {
        /** redis从节点名称。 */
        @JsonProperty("slaveName")
        private String slaveName;

        /** 连接地址。 */
        @JsonProperty("connUrl")
        private String connUrl;

        /**
         * 节点状态。
         * <li>CACHE.COMM.STATUS：正常。
         * <li>CACHE.DIAT.PREP：扩容数据准备。
         * <li>CACHE.DIAT.PROCESS：执行扩容数据。
         * <li>CACHE.DIAT.DEL：删除。
         * <li>CACHE.PROB.SWIT：故障待切换。
         */
        @JsonProperty("status")
        private String status;

        /** 从节点vpc连接地址。 */
        @JsonProperty("vpcUrl")
        private String vpcUrl;

        public String getSlaveName() {
            return this.slaveName;
        }

        public void setSlaveName(String slaveName) {
            this.slaveName = slaveName;
        }

        public String getConnUrl() {
            return this.connUrl;
        }

        public void setConnUrl(String connUrl) {
            this.connUrl = connUrl;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getVpcUrl() {
            return this.vpcUrl;
        }

        public void setVpcUrl(String vpcUrl) {
            this.vpcUrl = vpcUrl;
        }
    }
}
