package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询分布式缓存Redis实例大key、热key相关的任务结果。 */
public class Dcs2DescribeKeyTaskRecordApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeKeyTaskRecordApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/keyAnalysisMgrServant/describeKeyTaskRecord",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeKeyTaskRecordResponse send(
            Credential credential, DescribeKeyTaskRecordRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.taskId != null) {
            ctReq.addParam("taskId", request.taskId);
            request.taskId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeKeyTaskRecordResponse.class);
    }

    public static class DescribeKeyTaskRecordRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 任务ID。 */
        @JsonProperty("taskId")
        private String taskId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getTaskId() {
            return this.taskId;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }
    }

    public static class DescribeKeyTaskRecordResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeKeyTaskRecordReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeKeyTaskRecordReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeKeyTaskRecordReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeKeyTaskRecordReturnObjResponse {
        /** 任务状态。 */
        @JsonProperty("status")
        private String status;

        /** 任务开始查询时间。 */
        @JsonProperty("time")
        private String time;

        /** 热key(HotKeyNode)或大key(BigKeyNode)对象的集合。 */
        @JsonProperty("keyNodes")
        private List<DescribeKeyTaskRecordReturnObjKeyNodesResponse> keyNodes;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public List<DescribeKeyTaskRecordReturnObjKeyNodesResponse> getKeyNodes() {
            return this.keyNodes;
        }

        public void setKeyNodes(List<DescribeKeyTaskRecordReturnObjKeyNodesResponse> keyNodes) {
            this.keyNodes = keyNodes;
        }
    }

    public static class DescribeKeyTaskRecordReturnObjKeyNodesResponse {
        /** 要查询的key。 */
        @JsonProperty("key")
        private String key;

        /** 请求次数。 */
        @JsonProperty("queryCount")
        private String queryCount;

        /** 频次。 */
        @JsonProperty("counter")
        private Integer counter;

        /** 热key所在DB编号。 */
        @JsonProperty("db")
        private Integer db;

        /** 热key所在节点的url。 */
        @JsonProperty("nodeUrl")
        private String nodeUrl;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getQueryCount() {
            return this.queryCount;
        }

        public void setQueryCount(String queryCount) {
            this.queryCount = queryCount;
        }

        public Integer getCounter() {
            return this.counter;
        }

        public void setCounter(Integer counter) {
            this.counter = counter;
        }

        public Integer getDb() {
            return this.db;
        }

        public void setDb(Integer db) {
            this.db = db;
        }

        public String getNodeUrl() {
            return this.nodeUrl;
        }

        public void setNodeUrl(String nodeUrl) {
            this.nodeUrl = nodeUrl;
        }
    }
}
