package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询分布式缓存Redis实例基础详情。 */
public class Dcs2DescribeInstancesOverviewApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeInstancesOverviewApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/instanceManageMgrServant/describeInstancesOverview",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeInstancesOverviewResponse send(
            Credential credential, DescribeInstancesOverviewRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeInstancesOverviewResponse.class);
    }

    public static class DescribeInstancesOverviewRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }

    public static class DescribeInstancesOverviewResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private DescribeInstancesOverviewReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeInstancesOverviewReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeInstancesOverviewReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeInstancesOverviewReturnObjResponse {
        /** 总数。 */
        @JsonProperty("total")
        private Integer total;

        /** 实例名称信息。 */
        @JsonProperty("rows")
        private List<DescribeInstancesOverviewReturnObjRowsResponse> rows;

        /** 实例详情信息。 */
        @JsonProperty("userInfo")
        private DescribeInstancesOverviewReturnObjUserInfoResponse userInfo;

        /** redis节点信息。 */
        @JsonProperty("nodes")
        private List<DescribeInstancesOverviewReturnObjNodesResponse> nodes;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<DescribeInstancesOverviewReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<DescribeInstancesOverviewReturnObjRowsResponse> rows) {
            this.rows = rows;
        }

        public DescribeInstancesOverviewReturnObjUserInfoResponse getUserInfo() {
            return this.userInfo;
        }

        public void setUserInfo(DescribeInstancesOverviewReturnObjUserInfoResponse userInfo) {
            this.userInfo = userInfo;
        }

        public List<DescribeInstancesOverviewReturnObjNodesResponse> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<DescribeInstancesOverviewReturnObjNodesResponse> nodes) {
            this.nodes = nodes;
        }
    }

    public static class DescribeInstancesOverviewReturnObjRowsResponse {
        /** userName。 */
        @JsonProperty("userName")
        private String userName;

        /** 节点名称。 */
        @JsonProperty("name")
        private String name;

        /** 接入机名。 */
        @JsonProperty("accessSetName")
        private String accessSetName;

        /** Redis集群名。 */
        @JsonProperty("redisSetNames")
        private List<String> redisSetNames;

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAccessSetName() {
            return this.accessSetName;
        }

        public void setAccessSetName(String accessSetName) {
            this.accessSetName = accessSetName;
        }

        public List<String> getRedisSetNames() {
            return this.redisSetNames;
        }

        public void setRedisSetNames(List<String> redisSetNames) {
            this.redisSetNames = redisSetNames;
        }
    }

    public static class DescribeInstancesOverviewReturnObjUserInfoResponse {
        /** 实例ID。 */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 实例名称。 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 接入机集群名。 */
        @JsonProperty("accessSets")
        private String accessSets;

        /** REDIS集群名。 */
        @JsonProperty("redisSets")
        private String redisSets;

        /** redisSubSet。 */
        @JsonProperty("redisSubSet")
        private List<String> redisSubSet;

        /** vip地址。 */
        @JsonProperty("vip")
        private String vip;

        /** vipv6。 */
        @JsonProperty("vipv6")
        private String vipv6;

        /**
         * 实例状态。
         * <li>0：有效。
         * <li>1：开通中。
         * <li>2：暂停。
         * <li>3：变更中。
         * <li>4：开通失败。
         * <li>5：停止中。
         * <li>6：已停止。
         * <li>8：已退订。
         * <li>9：实例重启中。
         * <li>10：实例重启失败。
         * <li>11：网络变更中。
         * <li>-1：未知状态。
         */
        @JsonProperty("status")
        private Integer status;

        /** 状态英文名。 */
        @JsonProperty("statusName")
        private String statusName;

        /** 是否开启实例退订保护。 */
        @JsonProperty("protectionStatus")
        private Boolean protectionStatus;

        /** vip访问端口。 */
        @JsonProperty("vipPort")
        private Integer vipPort;

        /** 实例类型（可选值见枚举值type表）。 */
        @JsonProperty("type")
        private Integer type;

        /** 容量信息。 */
        @JsonProperty("capacityInfo")
        private String capacityInfo;

        /** 分片规格，单位为 GB。 */
        @JsonProperty("shardMemSize")
        private String shardMemSize;

        /** 分片数。 */
        @JsonProperty("shardCount")
        private String shardCount;

        /** 实例规格容量，单位为 GB。 */
        @JsonProperty("capacity")
        private String capacity;

        /** 副本数。 */
        @JsonProperty("copiesCount")
        private String copiesCount;

        /**
         * 付费类型。
         * <li>0：包年/包月。
         * <li>1: 按需。
         */
        @JsonProperty("payType")
        private Integer payType;

        /** 付费类型。 */
        @JsonProperty("payTypeName")
        private String payTypeName;

        /**
         * 是否绑定弹性IP。
         * <li>0:未绑定。
         * <li>1：已绑定。
         */
        @JsonProperty("elasticIpBind")
        private Integer elasticIpBind;

        /** 弹性IP。 */
        @JsonProperty("elasticIp")
        private String elasticIp;

        /** 弹性IP ID。 */
        @JsonProperty("outerElasticIpId")
        private String outerElasticIpId;

        /** 连接地址。 */
        @JsonProperty("connectionAddress")
        private String connectionAddress;

        /** ipv6连接地址。 */
        @JsonProperty("ipv6ConnectionAddress")
        private String ipv6ConnectionAddress;

        /** 访问白名单。 */
        @JsonProperty("whitelists")
        private String whitelists;

        /** 过期时间。 */
        @JsonProperty("expiration")
        private String expiration;

        /** 引擎版本。 */
        @JsonProperty("engineVersion")
        private String engineVersion;

        /** 引擎版本名 */
        @JsonProperty("engineVersionName")
        private String engineVersionName;

        /**
         * 架构类型。
         * <li>1：经典集群版。
         * <li>2：标准版。
         * <li>3：直连Cluster版。
         * <li>4：容量版。
         * <li>5：Proxy集群版。
         */
        @JsonProperty("archType")
        private String archType;

        /**
         * 节点类型。
         * <li>1：双副本。
         * <li>2：单副本。
         */
        @JsonProperty("nodeType")
        private String nodeType;

        /** 安全组。 */
        @JsonProperty("securityGroup")
        private String securityGroup;

        /** vpc网络名称。 */
        @JsonProperty("netName")
        private String netName;

        /** 子网名称。 */
        @JsonProperty("subnet")
        private String subnet;

        /** 创建时间。 */
        @JsonProperty("createTime")
        private String createTime;

        /** 过期时间。 */
        @JsonProperty("expTime")
        private String expTime;

        /** 架构类型。 */
        @JsonProperty("archTypeName")
        private String archTypeName;

        /** 节点类型名。 */
        @JsonProperty("nodeTypeName")
        private String nodeTypeName;

        /** 模板名称。 */
        @JsonProperty("tplName")
        private String tplName;

        /** 模板编码。 */
        @JsonProperty("tplCode")
        private String tplCode;

        /** 维护时间。 */
        @JsonProperty("maintenanceTime")
        private String maintenanceTime;

        /** 可用区列表。 */
        @JsonProperty("azList")
        private List<DescribeInstancesOverviewReturnObjUserInfoAzListResponse> azList;

        /** 属性列表。 */
        @JsonProperty("paasInstAttrs")
        private List<DescribeInstancesOverviewReturnObjUserInfoPaasInstAttrsResponse> paasInstAttrs;

        /** 实例描述信息。 */
        @JsonProperty("description")
        private String description;

        /** 是否开启读写分离。 */
        @JsonProperty("enableMultiRead")
        private Boolean enableMultiRead;

        /** 只读副本数。 */
        @JsonProperty("readReplica")
        private String readReplica;

        /** 是否开启弹性伸缩。 */
        @JsonProperty("autoScaleFlag")
        private Boolean autoScaleFlag;

        /**
         * CPU架构。
         * <li>x86。
         * <li>arm。
         */
        @JsonProperty("cpuArchType")
        private String cpuArchType;

        /** 网络信息 */
        @JsonProperty("networkInfo")
        private DescribeInstancesOverviewReturnObjUserInfoNetworkInfoResponse networkInfo;

        /** 数据盘类型。 */
        @JsonProperty("dataDiskType")
        private String dataDiskType;

        /** 数据盘类型名称。 */
        @JsonProperty("dataDiskTypeName")
        private String dataDiskTypeName;

        /** 系统盘类型。 */
        @JsonProperty("sysDiskType")
        private String sysDiskType;

        /** 系统盘类型名称。 */
        @JsonProperty("sysDiskTypeName")
        private String sysDiskTypeName;

        /** 主机类型名。 */
        @JsonProperty("hostType")
        private String hostType;

        /** 操作系统名。 */
        @JsonProperty("mirrorCategoryName")
        private String mirrorCategoryName;

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getAccessSets() {
            return this.accessSets;
        }

        public void setAccessSets(String accessSets) {
            this.accessSets = accessSets;
        }

        public String getRedisSets() {
            return this.redisSets;
        }

        public void setRedisSets(String redisSets) {
            this.redisSets = redisSets;
        }

        public List<String> getRedisSubSet() {
            return this.redisSubSet;
        }

        public void setRedisSubSet(List<String> redisSubSet) {
            this.redisSubSet = redisSubSet;
        }

        public String getVip() {
            return this.vip;
        }

        public void setVip(String vip) {
            this.vip = vip;
        }

        public String getVipv6() {
            return this.vipv6;
        }

        public void setVipv6(String vipv6) {
            this.vipv6 = vipv6;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getStatusName() {
            return this.statusName;
        }

        public void setStatusName(String statusName) {
            this.statusName = statusName;
        }

        public Boolean getProtectionStatus() {
            return this.protectionStatus;
        }

        public void setProtectionStatus(Boolean protectionStatus) {
            this.protectionStatus = protectionStatus;
        }

        public Integer getVipPort() {
            return this.vipPort;
        }

        public void setVipPort(Integer vipPort) {
            this.vipPort = vipPort;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getCapacityInfo() {
            return this.capacityInfo;
        }

        public void setCapacityInfo(String capacityInfo) {
            this.capacityInfo = capacityInfo;
        }

        public String getShardMemSize() {
            return this.shardMemSize;
        }

        public void setShardMemSize(String shardMemSize) {
            this.shardMemSize = shardMemSize;
        }

        public String getShardCount() {
            return this.shardCount;
        }

        public void setShardCount(String shardCount) {
            this.shardCount = shardCount;
        }

        public String getCapacity() {
            return this.capacity;
        }

        public void setCapacity(String capacity) {
            this.capacity = capacity;
        }

        public String getCopiesCount() {
            return this.copiesCount;
        }

        public void setCopiesCount(String copiesCount) {
            this.copiesCount = copiesCount;
        }

        public Integer getPayType() {
            return this.payType;
        }

        public void setPayType(Integer payType) {
            this.payType = payType;
        }

        public String getPayTypeName() {
            return this.payTypeName;
        }

        public void setPayTypeName(String payTypeName) {
            this.payTypeName = payTypeName;
        }

        public Integer getElasticIpBind() {
            return this.elasticIpBind;
        }

        public void setElasticIpBind(Integer elasticIpBind) {
            this.elasticIpBind = elasticIpBind;
        }

        public String getElasticIp() {
            return this.elasticIp;
        }

        public void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public String getOuterElasticIpId() {
            return this.outerElasticIpId;
        }

        public void setOuterElasticIpId(String outerElasticIpId) {
            this.outerElasticIpId = outerElasticIpId;
        }

        public String getConnectionAddress() {
            return this.connectionAddress;
        }

        public void setConnectionAddress(String connectionAddress) {
            this.connectionAddress = connectionAddress;
        }

        public String getIpv6ConnectionAddress() {
            return this.ipv6ConnectionAddress;
        }

        public void setIpv6ConnectionAddress(String ipv6ConnectionAddress) {
            this.ipv6ConnectionAddress = ipv6ConnectionAddress;
        }

        public String getWhitelists() {
            return this.whitelists;
        }

        public void setWhitelists(String whitelists) {
            this.whitelists = whitelists;
        }

        public String getExpiration() {
            return this.expiration;
        }

        public void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        public String getEngineVersion() {
            return this.engineVersion;
        }

        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public String getEngineVersionName() {
            return this.engineVersionName;
        }

        public void setEngineVersionName(String engineVersionName) {
            this.engineVersionName = engineVersionName;
        }

        public String getArchType() {
            return this.archType;
        }

        public void setArchType(String archType) {
            this.archType = archType;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public String getSecurityGroup() {
            return this.securityGroup;
        }

        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        public String getNetName() {
            return this.netName;
        }

        public void setNetName(String netName) {
            this.netName = netName;
        }

        public String getSubnet() {
            return this.subnet;
        }

        public void setSubnet(String subnet) {
            this.subnet = subnet;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getExpTime() {
            return this.expTime;
        }

        public void setExpTime(String expTime) {
            this.expTime = expTime;
        }

        public String getArchTypeName() {
            return this.archTypeName;
        }

        public void setArchTypeName(String archTypeName) {
            this.archTypeName = archTypeName;
        }

        public String getNodeTypeName() {
            return this.nodeTypeName;
        }

        public void setNodeTypeName(String nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
        }

        public String getTplName() {
            return this.tplName;
        }

        public void setTplName(String tplName) {
            this.tplName = tplName;
        }

        public String getTplCode() {
            return this.tplCode;
        }

        public void setTplCode(String tplCode) {
            this.tplCode = tplCode;
        }

        public String getMaintenanceTime() {
            return this.maintenanceTime;
        }

        public void setMaintenanceTime(String maintenanceTime) {
            this.maintenanceTime = maintenanceTime;
        }

        public List<DescribeInstancesOverviewReturnObjUserInfoAzListResponse> getAzList() {
            return this.azList;
        }

        public void setAzList(
                List<DescribeInstancesOverviewReturnObjUserInfoAzListResponse> azList) {
            this.azList = azList;
        }

        public List<DescribeInstancesOverviewReturnObjUserInfoPaasInstAttrsResponse>
                getPaasInstAttrs() {
            return this.paasInstAttrs;
        }

        public void setPaasInstAttrs(
                List<DescribeInstancesOverviewReturnObjUserInfoPaasInstAttrsResponse>
                        paasInstAttrs) {
            this.paasInstAttrs = paasInstAttrs;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Boolean getEnableMultiRead() {
            return this.enableMultiRead;
        }

        public void setEnableMultiRead(Boolean enableMultiRead) {
            this.enableMultiRead = enableMultiRead;
        }

        public String getReadReplica() {
            return this.readReplica;
        }

        public void setReadReplica(String readReplica) {
            this.readReplica = readReplica;
        }

        public Boolean getAutoScaleFlag() {
            return this.autoScaleFlag;
        }

        public void setAutoScaleFlag(Boolean autoScaleFlag) {
            this.autoScaleFlag = autoScaleFlag;
        }

        public String getCpuArchType() {
            return this.cpuArchType;
        }

        public void setCpuArchType(String cpuArchType) {
            this.cpuArchType = cpuArchType;
        }

        public DescribeInstancesOverviewReturnObjUserInfoNetworkInfoResponse getNetworkInfo() {
            return this.networkInfo;
        }

        public void setNetworkInfo(
                DescribeInstancesOverviewReturnObjUserInfoNetworkInfoResponse networkInfo) {
            this.networkInfo = networkInfo;
        }

        public String getDataDiskType() {
            return this.dataDiskType;
        }

        public void setDataDiskType(String dataDiskType) {
            this.dataDiskType = dataDiskType;
        }

        public String getDataDiskTypeName() {
            return this.dataDiskTypeName;
        }

        public void setDataDiskTypeName(String dataDiskTypeName) {
            this.dataDiskTypeName = dataDiskTypeName;
        }

        public String getSysDiskType() {
            return this.sysDiskType;
        }

        public void setSysDiskType(String sysDiskType) {
            this.sysDiskType = sysDiskType;
        }

        public String getSysDiskTypeName() {
            return this.sysDiskTypeName;
        }

        public void setSysDiskTypeName(String sysDiskTypeName) {
            this.sysDiskTypeName = sysDiskTypeName;
        }

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public String getMirrorCategoryName() {
            return this.mirrorCategoryName;
        }

        public void setMirrorCategoryName(String mirrorCategoryName) {
            this.mirrorCategoryName = mirrorCategoryName;
        }
    }

    public static class DescribeInstancesOverviewReturnObjNodesResponse {
        /** 节点名称。 */
        @JsonProperty("masterName")
        private String masterName;

        /** 起始槽位。 */
        @JsonProperty("startSlot")
        private String startSlot;

        /** 结束槽位。 */
        @JsonProperty("endSlot")
        private String endSlot;

        /** 管理IP连接地址。 */
        @JsonProperty("connUrl")
        private String connUrl;

        /**
         * 节点状态。
         * <li>CACHE.COMM.STATUS：正常。
         * <li>CACHE.DIAT.PREP：扩容数据准备。
         * <li>CACHE.DIAT.PROCESS：执行扩容数据。
         * <li>CACHE.DIAT.DEL：删除。
         * <li>CACHE.PROB.SWIT：故障待切换。
         */
        @JsonProperty("status")
        private String status;

        /** 是否可用。 */
        @JsonProperty("enabled")
        private Boolean enabled;

        /** 从节点列表。 */
        @JsonProperty("slaveNodes")
        private List<DescribeInstancesOverviewReturnObjNodesSlaveNodesResponse> slaveNodes;

        /** vpc地址。 */
        @JsonProperty("vpcUrl")
        private String vpcUrl;

        /** 模块ID。 */
        @JsonProperty("spuInstDeployId")
        private String spuInstDeployId;

        /** 可用区ID。 */
        @JsonProperty("azId")
        private String azId;

        /** 可用区名称。 */
        @JsonProperty("azName")
        private String azName;

        public String getMasterName() {
            return this.masterName;
        }

        public void setMasterName(String masterName) {
            this.masterName = masterName;
        }

        public String getStartSlot() {
            return this.startSlot;
        }

        public void setStartSlot(String startSlot) {
            this.startSlot = startSlot;
        }

        public String getEndSlot() {
            return this.endSlot;
        }

        public void setEndSlot(String endSlot) {
            this.endSlot = endSlot;
        }

        public String getConnUrl() {
            return this.connUrl;
        }

        public void setConnUrl(String connUrl) {
            this.connUrl = connUrl;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public List<DescribeInstancesOverviewReturnObjNodesSlaveNodesResponse> getSlaveNodes() {
            return this.slaveNodes;
        }

        public void setSlaveNodes(
                List<DescribeInstancesOverviewReturnObjNodesSlaveNodesResponse> slaveNodes) {
            this.slaveNodes = slaveNodes;
        }

        public String getVpcUrl() {
            return this.vpcUrl;
        }

        public void setVpcUrl(String vpcUrl) {
            this.vpcUrl = vpcUrl;
        }

        public String getSpuInstDeployId() {
            return this.spuInstDeployId;
        }

        public void setSpuInstDeployId(String spuInstDeployId) {
            this.spuInstDeployId = spuInstDeployId;
        }

        public String getAzId() {
            return this.azId;
        }

        public void setAzId(String azId) {
            this.azId = azId;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }
    }

    public static class DescribeInstancesOverviewReturnObjUserInfoAzListResponse {
        /** 可用区ID。 */
        @JsonProperty("azId")
        private String azId;

        /** 可用区名称。 */
        @JsonProperty("azName")
        private String azName;

        /** 可用区英文名称。 */
        @JsonProperty("azEngName")
        private String azEngName;

        public String getAzId() {
            return this.azId;
        }

        public void setAzId(String azId) {
            this.azId = azId;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }

        public String getAzEngName() {
            return this.azEngName;
        }

        public void setAzEngName(String azEngName) {
            this.azEngName = azEngName;
        }
    }

    public static class DescribeInstancesOverviewReturnObjUserInfoPaasInstAttrsResponse {
        /** 属性键名。 */
        @JsonProperty("attrKey")
        private String attrKey;

        /** 属性键值。 */
        @JsonProperty("attrVal")
        private String attrVal;

        public String getAttrKey() {
            return this.attrKey;
        }

        public void setAttrKey(String attrKey) {
            this.attrKey = attrKey;
        }

        public String getAttrVal() {
            return this.attrVal;
        }

        public void setAttrVal(String attrVal) {
            this.attrVal = attrVal;
        }
    }

    public static class DescribeInstancesOverviewReturnObjUserInfoNetworkInfoResponse {
        /** 单分片基准带宽 */
        @JsonProperty("baseBandwidth")
        private String baseBandwidth;

        /** 单分片最大带宽 */
        @JsonProperty("maxBandwidth")
        private String maxBandwidth;

        /** 实例总基准带宽 */
        @JsonProperty("totalBaseBandwidth")
        private String totalBaseBandwidth;

        /** 实例总最大带宽 */
        @JsonProperty("totalMaxBandwidth")
        private String totalMaxBandwidth;

        /** 单分片最大连接数 */
        @JsonProperty("maxClients")
        private String maxClients;

        /** 实例总最大连接数 */
        @JsonProperty("totalMaxClients")
        private String totalMaxClients;

        public String getBaseBandwidth() {
            return this.baseBandwidth;
        }

        public void setBaseBandwidth(String baseBandwidth) {
            this.baseBandwidth = baseBandwidth;
        }

        public String getMaxBandwidth() {
            return this.maxBandwidth;
        }

        public void setMaxBandwidth(String maxBandwidth) {
            this.maxBandwidth = maxBandwidth;
        }

        public String getTotalBaseBandwidth() {
            return this.totalBaseBandwidth;
        }

        public void setTotalBaseBandwidth(String totalBaseBandwidth) {
            this.totalBaseBandwidth = totalBaseBandwidth;
        }

        public String getTotalMaxBandwidth() {
            return this.totalMaxBandwidth;
        }

        public void setTotalMaxBandwidth(String totalMaxBandwidth) {
            this.totalMaxBandwidth = totalMaxBandwidth;
        }

        public String getMaxClients() {
            return this.maxClients;
        }

        public void setMaxClients(String maxClients) {
            this.maxClients = maxClients;
        }

        public String getTotalMaxClients() {
            return this.totalMaxClients;
        }

        public void setTotalMaxClients(String totalMaxClients) {
            this.totalMaxClients = totalMaxClients;
        }
    }

    public static class DescribeInstancesOverviewReturnObjNodesSlaveNodesResponse {
        /** slaveName。 */
        @JsonProperty("slaveName")
        private String slaveName;

        /** 管理IP连接地址。 */
        @JsonProperty("connUrl")
        private String connUrl;

        /** 节点状态。 */
        @JsonProperty("status")
        private String status;

        /** 是否可用。 */
        @JsonProperty("enabled")
        private Boolean enabled;

        /** vpc地址。 */
        @JsonProperty("vpcUrl")
        private String vpcUrl;

        /** 模块ID。 */
        @JsonProperty("spuInstDeployId")
        private String spuInstDeployId;

        /** 可用区ID。 */
        @JsonProperty("azId")
        private String azId;

        /** 可用区名称。 */
        @JsonProperty("azName")
        private String azName;

        public String getSlaveName() {
            return this.slaveName;
        }

        public void setSlaveName(String slaveName) {
            this.slaveName = slaveName;
        }

        public String getConnUrl() {
            return this.connUrl;
        }

        public void setConnUrl(String connUrl) {
            this.connUrl = connUrl;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getVpcUrl() {
            return this.vpcUrl;
        }

        public void setVpcUrl(String vpcUrl) {
            this.vpcUrl = vpcUrl;
        }

        public String getSpuInstDeployId() {
            return this.spuInstDeployId;
        }

        public void setSpuInstDeployId(String spuInstDeployId) {
            this.spuInstDeployId = spuInstDeployId;
        }

        public String getAzId() {
            return this.azId;
        }

        public void setAzId(String azId) {
            this.azId = azId;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }
    }
}
