package cn.ctyun.apis;

import cn.ctyun.sdk.*;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

/** 批量查询租户的缓存redis集群节点信息。 */
public class Dcs2DescribeInstancesClusterMemberInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeInstancesClusterMemberInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/instanceManageMgrServant/describeInstancesClusterMemberInfo",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeInstancesClusterMemberInfoResponse send(
            Credential credential, DescribeInstancesClusterMemberInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.projectId != null) {
            ctReq.addParam("projectId", request.projectId);
            request.projectId = null;
        }
        if (request.pageIndex != null) {
            ctReq.addParam("pageIndex", String.valueOf(request.pageIndex));
            request.pageIndex = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeInstancesClusterMemberInfoResponse.class);
    }

    public static class DescribeInstancesClusterMemberInfoRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 企业项目ID(默认值：0)，可以通过 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=77&api=7246&data=114&isNormal=1&vid=107">查询企业项目列表</a>
         * 接口，使用recordList表id字段。
         */
        @JsonProperty("projectId")
        private String projectId;

        /** 当前页码。 */
        @JsonProperty("pageIndex")
        private Integer pageIndex;

        /** 每页大小。 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        public Integer getPageIndex() {
            return this.pageIndex;
        }

        public void setPageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }
    }

    public static class DescribeInstancesClusterMemberInfoResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private DescribeInstancesClusterMemberInfoReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeInstancesClusterMemberInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeInstancesClusterMemberInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeInstancesClusterMemberInfoReturnObjResponse {
        /** 实例数。 */
        @JsonProperty("total")
        private Integer total;

        /** redis集群列表。 */
        @JsonProperty("instances")
        private List<DescribeInstancesClusterMemberInfoReturnObjInstancesResponse> instances;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<DescribeInstancesClusterMemberInfoReturnObjInstancesResponse> getInstances() {
            return this.instances;
        }

        public void setInstances(
                List<DescribeInstancesClusterMemberInfoReturnObjInstancesResponse> instances) {
            this.instances = instances;
        }
    }

    public static class DescribeInstancesClusterMemberInfoReturnObjInstancesResponse {
        /** 实例ID。 */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 节点数。 */
        @JsonProperty("total")
        private Integer total;

        /** 返回Redis集群节点详细信息。 */
        @JsonProperty("rows")
        private List<DescribeInstancesClusterMemberInfoReturnObjInstancesRowsResponse> rows;

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<DescribeInstancesClusterMemberInfoReturnObjInstancesRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(
                List<DescribeInstancesClusterMemberInfoReturnObjInstancesRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class DescribeInstancesClusterMemberInfoReturnObjInstancesRowsResponse {
        /** Redis集群名。 */
        @JsonProperty("redisSetName")
        private String redisSetName;

        /** Redis集群节点信息。 */
        @JsonProperty("redisSetInfo")
        private String redisSetInfo;

        /** 更新时间戳。 */
        @JsonProperty("lastestTime")
        private String lastestTime;

        /**
         * 是否读写分离。
         * <li>true：开启。
         * <li>false：关闭。
         */
        @JsonProperty("isRWsep")
        private Boolean isRWsep;

        /** Redis节点集合，数据见RedisNode。 */
        @JsonProperty("nodes")
        private List<DescribeInstancesClusterMemberInfoReturnObjInstancesRowsNodesResponse> nodes;

        /** 槽位信息。 */
        @JsonProperty("slotInfo")
        private String slotInfo;

        /** 是否加密鉴权。 */
        @JsonProperty("isAuth")
        private Boolean isAuth;

        /** 实例类型（可选值见枚举值type表）。 */
        @JsonProperty("type")
        private Integer type;

        public String getRedisSetName() {
            return this.redisSetName;
        }

        public void setRedisSetName(String redisSetName) {
            this.redisSetName = redisSetName;
        }

        public String getRedisSetInfo() {
            return this.redisSetInfo;
        }

        public void setRedisSetInfo(String redisSetInfo) {
            this.redisSetInfo = redisSetInfo;
        }

        public String getLastestTime() {
            return this.lastestTime;
        }

        public void setLastestTime(String lastestTime) {
            this.lastestTime = lastestTime;
        }

        public Boolean getIsRWsep() {
            return this.isRWsep;
        }

        public void setIsRWsep(Boolean isRWsep) {
            this.isRWsep = isRWsep;
        }

        public List<DescribeInstancesClusterMemberInfoReturnObjInstancesRowsNodesResponse>
                getNodes() {
            return this.nodes;
        }

        public void setNodes(
                List<DescribeInstancesClusterMemberInfoReturnObjInstancesRowsNodesResponse> nodes) {
            this.nodes = nodes;
        }

        public String getSlotInfo() {
            return this.slotInfo;
        }

        public void setSlotInfo(String slotInfo) {
            this.slotInfo = slotInfo;
        }

        public Boolean getIsAuth() {
            return this.isAuth;
        }

        public void setIsAuth(Boolean isAuth) {
            this.isAuth = isAuth;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }
    }

    public static class DescribeInstancesClusterMemberInfoReturnObjInstancesRowsNodesResponse {
        /** 主节点名称。 */
        @JsonProperty("masterName")
        private String masterName;

        /** 分片名称。 */
        @JsonProperty("fragmentName")
        private String fragmentName;

        /** 开始槽位。 */
        @JsonProperty("startSlot")
        private String startSlot;

        /** 结束槽位。 */
        @JsonProperty("endSlot")
        private String endSlot;

        /** 连接地址。 */
        @JsonProperty("connUrl")
        private String connUrl;

        /** 可用区名称。 */
        @JsonProperty("azName")
        private String azName;

        /**
         * 节点状态。
         * <li>CACHE.COMM.STATUS：正常。
         * <li>CACHE.DIAT.PREP：扩容数据准备。
         * <li>CACHE.DIAT.PROCESS：执行扩容数据。
         * <li>CACHE.DIAT.DEL：删除。
         * <li>CACHE.PROB.SWIT：故障待切换。
         */
        @JsonProperty("status")
        private String status;

        /** 是否可用状态。 */
        @JsonProperty("enabled")
        private Boolean enabled;

        /** 从节点数组，数据见SlaveNode。 */
        @JsonProperty("slaveNodes")
        private List<
                DescribeInstancesClusterMemberInfoReturnObjInstancesRowsNodesSlaveNodesResponse>
                slaveNodes;

        /** vpc连接地址。 */
        @JsonProperty("vpcUrl")
        private String vpcUrl;

        public String getMasterName() {
            return this.masterName;
        }

        public void setMasterName(String masterName) {
            this.masterName = masterName;
        }

        public String getFragmentName() {
            return this.fragmentName;
        }

        public void setFragmentName(String fragmentName) {
            this.fragmentName = fragmentName;
        }

        public String getStartSlot() {
            return this.startSlot;
        }

        public void setStartSlot(String startSlot) {
            this.startSlot = startSlot;
        }

        public String getEndSlot() {
            return this.endSlot;
        }

        public void setEndSlot(String endSlot) {
            this.endSlot = endSlot;
        }

        public String getConnUrl() {
            return this.connUrl;
        }

        public void setConnUrl(String connUrl) {
            this.connUrl = connUrl;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public List<DescribeInstancesClusterMemberInfoReturnObjInstancesRowsNodesSlaveNodesResponse>
        getSlaveNodes() {
            return this.slaveNodes;
        }

        public void setSlaveNodes(
                List<
                        DescribeInstancesClusterMemberInfoReturnObjInstancesRowsNodesSlaveNodesResponse>
                        slaveNodes) {
            this.slaveNodes = slaveNodes;
        }

        public String getVpcUrl() {
            return this.vpcUrl;
        }

        public void setVpcUrl(String vpcUrl) {
            this.vpcUrl = vpcUrl;
        }
    }

    public static
    class DescribeInstancesClusterMemberInfoReturnObjInstancesRowsNodesSlaveNodesResponse {
        /** Redis从节点名称。 */
        @JsonProperty("slaveName")
        private String slaveName;

        /** 连接地址。 */
        @JsonProperty("connUrl")
        private String connUrl;

        /** 可用区名称。 */
        @JsonProperty("azName")
        private String azName;

        /**
         * 节点状态。
         * <li>CACHE.COMM.STATUS：正常。
         * <li>CACHE.DIAT.PREP：扩容数据准备。
         * <li>CACHE.DIAT.PROCESS：执行扩容数据。
         * <li>CACHE.DIAT.DEL：删除。
         * <li>CACHE.PROB.SWIT：故障待切换。
         */
        @JsonProperty("status")
        private String status;

        /** 是否可用状态。 */
        @JsonProperty("enabled")
        private Boolean enabled;

        /** 从节点vpc连接地址。 */
        @JsonProperty("vpcUrl")
        private String vpcUrl;

        public String getSlaveName() {
            return this.slaveName;
        }

        public void setSlaveName(String slaveName) {
            this.slaveName = slaveName;
        }

        public String getConnUrl() {
            return this.connUrl;
        }

        public void setConnUrl(String connUrl) {
            this.connUrl = connUrl;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getVpcUrl() {
            return this.vpcUrl;
        }

        public void setVpcUrl(String vpcUrl) {
            this.vpcUrl = vpcUrl;
        }
    }
}
