package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询分布式缓存Redis实例版本信息。 */
public class Dcs2DescribeInstanceVersionApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeInstanceVersionApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/instanceManageMgrServant/describeInstanceVersion",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeInstanceVersionResponse send(
            Credential credential, DescribeInstanceVersionRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeInstanceVersionResponse.class);
    }

    public static class DescribeInstanceVersionRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }

    public static class DescribeInstanceVersionResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private DescribeInstanceVersionReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeInstanceVersionReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeInstanceVersionReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeInstanceVersionReturnObjResponse {
        /** 引擎大版本信息。 */
        @JsonProperty("engineMajorVersionInfo")
        private DescribeInstanceVersionReturnObjEngineMajorVersionInfoResponse
                engineMajorVersionInfo;

        /** 引擎小版本信息。 */
        @JsonProperty("engineMinorVersionInfo")
        private DescribeInstanceVersionReturnObjEngineMinorVersionInfoResponse
                engineMinorVersionInfo;

        /** 代理版本信息。 */
        @JsonProperty("proxyVersionInfo")
        private DescribeInstanceVersionReturnObjProxyVersionInfoResponse proxyVersionInfo;

        public DescribeInstanceVersionReturnObjEngineMajorVersionInfoResponse
                getEngineMajorVersionInfo() {
            return this.engineMajorVersionInfo;
        }

        public void setEngineMajorVersionInfo(
                DescribeInstanceVersionReturnObjEngineMajorVersionInfoResponse
                        engineMajorVersionInfo) {
            this.engineMajorVersionInfo = engineMajorVersionInfo;
        }

        public DescribeInstanceVersionReturnObjEngineMinorVersionInfoResponse
                getEngineMinorVersionInfo() {
            return this.engineMinorVersionInfo;
        }

        public void setEngineMinorVersionInfo(
                DescribeInstanceVersionReturnObjEngineMinorVersionInfoResponse
                        engineMinorVersionInfo) {
            this.engineMinorVersionInfo = engineMinorVersionInfo;
        }

        public DescribeInstanceVersionReturnObjProxyVersionInfoResponse getProxyVersionInfo() {
            return this.proxyVersionInfo;
        }

        public void setProxyVersionInfo(
                DescribeInstanceVersionReturnObjProxyVersionInfoResponse proxyVersionInfo) {
            this.proxyVersionInfo = proxyVersionInfo;
        }
    }

    public static class DescribeInstanceVersionReturnObjEngineMajorVersionInfoResponse {
        /** 引擎大版本。 */
        @JsonProperty("engineMajorVersion")
        private String engineMajorVersion;

        /** 引擎所有大版本列表。 */
        @JsonProperty("engineVersionItems")
        private List<String> engineVersionItems;

        /** 引擎可升级大版本列表。 */
        @JsonProperty("upgradableEngineVersionItems")
        private List<String> upgradableEngineVersionItems;

        public String getEngineMajorVersion() {
            return this.engineMajorVersion;
        }

        public void setEngineMajorVersion(String engineMajorVersion) {
            this.engineMajorVersion = engineMajorVersion;
        }

        public List<String> getEngineVersionItems() {
            return this.engineVersionItems;
        }

        public void setEngineVersionItems(List<String> engineVersionItems) {
            this.engineVersionItems = engineVersionItems;
        }

        public List<String> getUpgradableEngineVersionItems() {
            return this.upgradableEngineVersionItems;
        }

        public void setUpgradableEngineVersionItems(List<String> upgradableEngineVersionItems) {
            this.upgradableEngineVersionItems = upgradableEngineVersionItems;
        }
    }

    public static class DescribeInstanceVersionReturnObjEngineMinorVersionInfoResponse {
        /** 引擎小版本。 */
        @JsonProperty("engineMinorVersion")
        private String engineMinorVersion;

        /** 引擎可升级小版本列表。 */
        @JsonProperty("upgradableEngineMinorVersionItems")
        private List<String> upgradableEngineMinorVersionItems;

        public String getEngineMinorVersion() {
            return this.engineMinorVersion;
        }

        public void setEngineMinorVersion(String engineMinorVersion) {
            this.engineMinorVersion = engineMinorVersion;
        }

        public List<String> getUpgradableEngineMinorVersionItems() {
            return this.upgradableEngineMinorVersionItems;
        }

        public void setUpgradableEngineMinorVersionItems(
                List<String> upgradableEngineMinorVersionItems) {
            this.upgradableEngineMinorVersionItems = upgradableEngineMinorVersionItems;
        }
    }

    public static class DescribeInstanceVersionReturnObjProxyVersionInfoResponse {
        /** 代理版本。 */
        @JsonProperty("proxyMinorVersion")
        private String proxyMinorVersion;

        /** 可升级代理版本列表。 */
        @JsonProperty("upgradableProxyMinorVersions")
        private List<String> upgradableProxyMinorVersions;

        public String getProxyMinorVersion() {
            return this.proxyMinorVersion;
        }

        public void setProxyMinorVersion(String proxyMinorVersion) {
            this.proxyMinorVersion = proxyMinorVersion;
        }

        public List<String> getUpgradableProxyMinorVersions() {
            return this.upgradableProxyMinorVersions;
        }

        public void setUpgradableProxyMinorVersions(List<String> upgradableProxyMinorVersions) {
            this.upgradableProxyMinorVersions = upgradableProxyMinorVersions;
        }
    }
}
