package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 查询分布式缓存Redis实例配置参数。 */
public class Dcs2DescribeInstanceConfigV2Api {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeInstanceConfigV2Api(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/instanceParam/describeInstanceConfig", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeInstanceConfigV2Response send(
            Credential credential, DescribeInstanceConfigV2Request request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeInstanceConfigV2Response.class);
    }

    public static class DescribeInstanceConfigV2Request {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }

    public static class DescribeInstanceConfigV2Response {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeInstanceConfigV2ReturnObjResponse returnObj;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeInstanceConfigV2ReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeInstanceConfigV2ReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeInstanceConfigV2ReturnObjResponse {
        /** 指定redis最大内存限制，1-1099511627776整数。 */
        @JsonProperty("maxmemory")
        private String maxmemory;

        /** 设置数据库的数量。 */
        @JsonProperty("databases")
        private String databases;

        /** 是否打开半同步开关。 */
        @JsonProperty("isOpenSemiSync")
        private String isOpenSemiSync;

        /**
         * 指定日志更新条件。
         * <li>no
         * <li>everysec
         * <li>always
         */
        @JsonProperty("appendfsync")
        private String appendfsync;

        /** 指定本地数据库存放目录。 */
        @JsonProperty("dir")
        private String dir;

        /**
         * 指定日志记录级别：
         * <li>debug
         * <li>verbose
         * <li>notice
         * <li>warning。
         */
        @JsonProperty("loglevel")
        private String loglevel;

        /** 指定日志文件。 */
        @JsonProperty("logfile")
        private String logfile;

        /** 默认的aof文件重写大小。 */
        @JsonProperty("aofNewsaveSize")
        private String aofNewsaveSize;

        /** 同一时间最大客户端连接数。 */
        @JsonProperty("maxclients")
        private String maxclients;

        /** 是否开启乐观锁模板。 */
        @JsonProperty("isOpenVersion")
        private String isOpenVersion;

        /** 默认的aof文件重写内存占比的大小。 */
        @JsonProperty("aofNewsavePercentage")
        private String aofNewsavePercentage;

        public String getMaxmemory() {
            return this.maxmemory;
        }

        public void setMaxmemory(String maxmemory) {
            this.maxmemory = maxmemory;
        }

        public String getDatabases() {
            return this.databases;
        }

        public void setDatabases(String databases) {
            this.databases = databases;
        }

        public String getIsOpenSemiSync() {
            return this.isOpenSemiSync;
        }

        public void setIsOpenSemiSync(String isOpenSemiSync) {
            this.isOpenSemiSync = isOpenSemiSync;
        }

        public String getAppendfsync() {
            return this.appendfsync;
        }

        public void setAppendfsync(String appendfsync) {
            this.appendfsync = appendfsync;
        }

        public String getDir() {
            return this.dir;
        }

        public void setDir(String dir) {
            this.dir = dir;
        }

        public String getLoglevel() {
            return this.loglevel;
        }

        public void setLoglevel(String loglevel) {
            this.loglevel = loglevel;
        }

        public String getLogfile() {
            return this.logfile;
        }

        public void setLogfile(String logfile) {
            this.logfile = logfile;
        }

        public String getAofNewsaveSize() {
            return this.aofNewsaveSize;
        }

        public void setAofNewsaveSize(String aofNewsaveSize) {
            this.aofNewsaveSize = aofNewsaveSize;
        }

        public String getMaxclients() {
            return this.maxclients;
        }

        public void setMaxclients(String maxclients) {
            this.maxclients = maxclients;
        }

        public String getIsOpenVersion() {
            return this.isOpenVersion;
        }

        public void setIsOpenVersion(String isOpenVersion) {
            this.isOpenVersion = isOpenVersion;
        }

        public String getAofNewsavePercentage() {
            return this.aofNewsavePercentage;
        }

        public void setAofNewsavePercentage(String aofNewsavePercentage) {
            this.aofNewsavePercentage = aofNewsavePercentage;
        }
    }
}
