package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询分布式缓存Redis实例的配置参数。 */
public class Dcs2DescribeInstanceConfigApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeInstanceConfigApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v3/instanceParam/describeInstanceConfig", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeInstanceConfigResponse send(
            Credential credential, DescribeInstanceConfigRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeInstanceConfigResponse.class);
    }

    public static class DescribeInstanceConfigRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }

    public static class DescribeInstanceConfigResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeInstanceConfigReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeInstanceConfigReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeInstanceConfigReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeInstanceConfigReturnObjResponse {
        /** 数量 */
        @JsonProperty("total")
        private Integer total;

        /** 参数对象 */
        @JsonProperty("rows")
        private List<DescribeInstanceConfigReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<DescribeInstanceConfigReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<DescribeInstanceConfigReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class DescribeInstanceConfigReturnObjRowsResponse {
        /** 参数名称。 */
        @JsonProperty("paramName")
        private String paramName;

        /** 参数描述。 */
        @JsonProperty("description")
        private String description;

        /** 参数范围。 */
        @JsonProperty("valueRange")
        private String valueRange;

        /** 默认值。 */
        @JsonProperty("defaultValue")
        private String defaultValue;

        /**
         * 参数修改后是否需要重启实例。
         * <li>true：需要重启。
         * <li>false：无需重启。
         */
        @JsonProperty("needRestart")
        private Boolean needRestart;

        /** 当前值。 */
        @JsonProperty("currentValue")
        private String currentValue;

        public String getParamName() {
            return this.paramName;
        }

        public void setParamName(String paramName) {
            this.paramName = paramName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getValueRange() {
            return this.valueRange;
        }

        public void setValueRange(String valueRange) {
            this.valueRange = valueRange;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public Boolean getNeedRestart() {
            return this.needRestart;
        }

        public void setNeedRestart(Boolean needRestart) {
            this.needRestart = needRestart;
        }

        public String getCurrentValue() {
            return this.currentValue;
        }

        public void setCurrentValue(String currentValue) {
            this.currentValue = currentValue;
        }
    }
}
