package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询分布式缓存Redis实例或节点支持的性能监控项列表。 */
public class Dcs2DescribeHistoryMonitorItemsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeHistoryMonitorItemsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/resourceMonitor/describeHistoryMonitorItems",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeHistoryMonitorItemsResponse send(
            Credential credential, DescribeHistoryMonitorItemsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeHistoryMonitorItemsResponse.class);
    }

    public static class DescribeHistoryMonitorItemsRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表
         * </a>接口获取prodInstId字段。若prodInstId不为空，则会根据实例类型过滤监控指标。针对“节点每秒请求错误数”指标，Redis6.0/7.0才统计。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }

    public static class DescribeHistoryMonitorItemsResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeHistoryMonitorItemsReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeHistoryMonitorItemsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeHistoryMonitorItemsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeHistoryMonitorItemsReturnObjResponse {
        /** 实例基本指标集合。 */
        @JsonProperty("instanceMonitorList")
        private List<DescribeHistoryMonitorItemsReturnObjInstanceMonitorListResponse>
                instanceMonitorList;

        /** 节点指标集合。 */
        @JsonProperty("nodeMonitorList")
        private List<DescribeHistoryMonitorItemsReturnObjNodeMonitorListResponse> nodeMonitorList;

        /** 代理节点指标集合。 */
        @JsonProperty("proxyNodeMonitorList")
        private List<DescribeHistoryMonitorItemsReturnObjProxyNodeMonitorListResponse>
                proxyNodeMonitorList;

        /** 命令指标监控集合。 */
        @JsonProperty("commandMonitorList")
        private List<DescribeHistoryMonitorItemsReturnObjCommandMonitorListResponse>
                commandMonitorList;

        public List<DescribeHistoryMonitorItemsReturnObjInstanceMonitorListResponse>
                getInstanceMonitorList() {
            return this.instanceMonitorList;
        }

        public void setInstanceMonitorList(
                List<DescribeHistoryMonitorItemsReturnObjInstanceMonitorListResponse>
                        instanceMonitorList) {
            this.instanceMonitorList = instanceMonitorList;
        }

        public List<DescribeHistoryMonitorItemsReturnObjNodeMonitorListResponse>
                getNodeMonitorList() {
            return this.nodeMonitorList;
        }

        public void setNodeMonitorList(
                List<DescribeHistoryMonitorItemsReturnObjNodeMonitorListResponse> nodeMonitorList) {
            this.nodeMonitorList = nodeMonitorList;
        }

        public List<DescribeHistoryMonitorItemsReturnObjProxyNodeMonitorListResponse>
                getProxyNodeMonitorList() {
            return this.proxyNodeMonitorList;
        }

        public void setProxyNodeMonitorList(
                List<DescribeHistoryMonitorItemsReturnObjProxyNodeMonitorListResponse>
                        proxyNodeMonitorList) {
            this.proxyNodeMonitorList = proxyNodeMonitorList;
        }

        public List<DescribeHistoryMonitorItemsReturnObjCommandMonitorListResponse>
                getCommandMonitorList() {
            return this.commandMonitorList;
        }

        public void setCommandMonitorList(
                List<DescribeHistoryMonitorItemsReturnObjCommandMonitorListResponse>
                        commandMonitorList) {
            this.commandMonitorList = commandMonitorList;
        }
    }

    public static class DescribeHistoryMonitorItemsReturnObjInstanceMonitorListResponse {
        /** 类型。 */
        @JsonProperty("type")
        private String type;

        /** 描述。 */
        @JsonProperty("desc")
        private String desc;

        /** 单位。 */
        @JsonProperty("unit")
        private String unit;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }
    }

    public static class DescribeHistoryMonitorItemsReturnObjNodeMonitorListResponse {
        /** 类型。 */
        @JsonProperty("type")
        private String type;

        /** 描述。 */
        @JsonProperty("desc")
        private String desc;

        /** 单位。 */
        @JsonProperty("unit")
        private String unit;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }
    }

    public static class DescribeHistoryMonitorItemsReturnObjProxyNodeMonitorListResponse {
        /** 类型。 */
        @JsonProperty("type")
        private String type;

        /** 描述。 */
        @JsonProperty("desc")
        private String desc;

        /** 单位。 */
        @JsonProperty("unit")
        private String unit;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }
    }

    public static class DescribeHistoryMonitorItemsReturnObjCommandMonitorListResponse {
        /** 类型。 */
        @JsonProperty("type")
        private String type;

        /** 描述。 */
        @JsonProperty("desc")
        private String desc;

        /** 单位。 */
        @JsonProperty("unit")
        private String unit;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getUnit() {
            return this.unit;
        }

        public void setUnit(String unit) {
            this.unit = unit;
        }
    }
}
