package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询专属集群产品实例列表。 */
public class Dcs2DescribeDedicatedClusterInstanceListApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeDedicatedClusterInstanceListApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/instanceManageMgrServant/describeDedicatedClusterInstanceList",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeDedicatedClusterInstanceListResponse send(
            Credential credential, DescribeDedicatedClusterInstanceListRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.pageIndex != null) {
            ctReq.addParam("pageIndex", String.valueOf(request.pageIndex));
            request.pageIndex = null;
        }
        if (request.pageSize != null) {
            ctReq.addParam("pageSize", String.valueOf(request.pageSize));
            request.pageSize = null;
        }
        if (request.instanceName != null) {
            ctReq.addParam("instanceName", request.instanceName);
            request.instanceName = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeDedicatedClusterInstanceListResponse.class);
    }

    public static class DescribeDedicatedClusterInstanceListRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 当前页码。默认1 */
        @JsonProperty("pageIndex")
        private Integer pageIndex;

        /** 每页大小。默认10 */
        @JsonProperty("pageSize")
        private Integer pageSize;

        /** 实例名称。用于模糊搜索 */
        @JsonProperty("instanceName")
        private String instanceName;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public Integer getPageIndex() {
            return this.pageIndex;
        }

        public void setPageIndex(Integer pageIndex) {
            this.pageIndex = pageIndex;
        }

        public Integer getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }

    public static class DescribeDedicatedClusterInstanceListResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeDedicatedClusterInstanceListReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeDedicatedClusterInstanceListReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeDedicatedClusterInstanceListReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeDedicatedClusterInstanceListReturnObjResponse {
        /** 总数。 */
        @JsonProperty("total")
        private Integer total;

        /** UserInfo对象列表。 */
        @JsonProperty("rows")
        private List<DescribeDedicatedClusterInstanceListReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<DescribeDedicatedClusterInstanceListReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<DescribeDedicatedClusterInstanceListReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class DescribeDedicatedClusterInstanceListReturnObjRowsResponse {
        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 实例名称。 */
        @JsonProperty("instanceName")
        private String instanceName;

        /** 接入机集群名。 */
        @JsonProperty("accessSets")
        private String accessSets;

        /** Redis集群名。 */
        @JsonProperty("redisSets")
        private String redisSets;

        /** vip地址。 */
        @JsonProperty("vip")
        private String vip;

        /** IPV6格式的vip地址。 */
        @JsonProperty("vipv6")
        private String vipv6;

        /**
         * 实例状态。
         * <li>0：有效。
         * <li>1：开通中。
         * <li>2：暂停。
         * <li>3：变更中。
         * <li>4：开通失败。
         * <li>5：停止中。
         * <li>6：已停止。
         * <li>8：已退订。
         * <li>9：实例重启中。
         * <li>10：实例重启失败。
         * <li>11：网络变更中。
         * <li>-1：未知状态。
         */
        @JsonProperty("status")
        private Integer status;

        /** vip访问端口。 */
        @JsonProperty("vipPort")
        private Integer vipPort;

        /** 实例类型（可选值见枚举值type表）。 */
        @JsonProperty("type")
        private Integer type;

        /** 容量信息。 */
        @JsonProperty("capacityInfo")
        private String capacityInfo;

        /**
         * 付费类型。
         * <li>0：包年/包月。
         * <li>1: 按需。
         */
        @JsonProperty("payType")
        private Integer payType;

        /** 付费类型名。 */
        @JsonProperty("payTypeName")
        private String payTypeName;

        /**
         * 是否绑定弹性IP。
         * <li>0：未绑定。
         * <li>1：已绑定。
         */
        @JsonProperty("elasticIpBind")
        private Integer elasticIpBind;

        /** 弹性IP。 */
        @JsonProperty("elasticIp")
        private String elasticIp;

        /** 弹性IP ID。 */
        @JsonProperty("outerElasticIpId")
        private String outerElasticIpId;

        /** 访问白名单。。 */
        @JsonProperty("whitelists")
        private String whitelists;

        /** 过期时间。 */
        @JsonProperty("expiration")
        private String expiration;

        /** 引擎版本。 */
        @JsonProperty("engineVersion")
        private String engineVersion;

        /** 引擎版本名。 */
        @JsonProperty("engineVersionName")
        private String engineVersionName;

        /**
         * 架构类型。
         * <li>1：经典集群版。
         * <li>2：标准版。
         * <li>3：直连Cluster版。
         * <li>4：容量版。
         * <li>5：Proxy集群版。
         */
        @JsonProperty("archType")
        private String archType;

        /**
         * 节点类型。
         * <li>1：双副本。
         * <li>2：单副本。
         */
        @JsonProperty("nodeType")
        private String nodeType;

        /** 安全组。 */
        @JsonProperty("securityGroup")
        private String securityGroup;

        /** vpc网络名称。 */
        @JsonProperty("netName")
        private String netName;

        /** 子网名称。 */
        @JsonProperty("subnet")
        private String subnet;

        /** 创建时间。 */
        @JsonProperty("createTime")
        private String createTime;

        /** 过期时间。 */
        @JsonProperty("expTime")
        private String expTime;

        /** 架构类型。 */
        @JsonProperty("archTypeName")
        private String archTypeName;

        /** 节点类型名。 */
        @JsonProperty("nodeTypeName")
        private String nodeTypeName;

        /** 模板名称。 */
        @JsonProperty("tplName")
        private String tplName;

        /** 模板编码。 */
        @JsonProperty("tplCode")
        private String tplCode;

        /** 维护时间。 */
        @JsonProperty("maintenanceTime")
        private String maintenanceTime;

        /** 可用区列表。 */
        @JsonProperty("azList")
        private List<DescribeDedicatedClusterInstanceListReturnObjRowsAzListResponse> azList;

        /** 状态名称。 */
        @JsonProperty("statusName")
        private String statusName;

        /** 实例退订保护状态。 */
        @JsonProperty("protectionStatus")
        private Boolean protectionStatus;

        /** 副本数。 */
        @JsonProperty("copiesCount")
        private String copiesCount;

        /** 只读副本数。 */
        @JsonProperty("readReplica")
        private String readReplica;

        /** 分片数。 */
        @JsonProperty("shardCount")
        private String shardCount;

        /** 实例标签列表。 */
        @JsonProperty("labels")
        private List<DescribeDedicatedClusterInstanceListReturnObjRowsLabelsResponse> labels;

        /**
         * CPU架构。
         * <li>x86。
         * <li>arm。
         */
        @JsonProperty("cpuArchType")
        private String cpuArchType;

        /** 企业项目ID。 */
        @JsonProperty("outerProjectId")
        private String outerProjectId;

        /** 项目名。 */
        @JsonProperty("outerProjectName")
        private String outerProjectName;

        /** 数据盘类型。 */
        @JsonProperty("dataDiskType")
        private String dataDiskType;

        /** 数据盘类型名称。 */
        @JsonProperty("dataDiskTypeName")
        private String dataDiskTypeName;

        /** 系统盘类型。 */
        @JsonProperty("sysDiskType")
        private String sysDiskType;

        /** 系统盘类型名称。 */
        @JsonProperty("sysDiskTypeName")
        private String sysDiskTypeName;

        /** 主机类型名。 */
        @JsonProperty("hostType")
        private String hostType;

        /** 操作系统名。 */
        @JsonProperty("mirrorCategoryName")
        private String mirrorCategoryName;

        /** 实例描述信息。 */
        @JsonProperty("description")
        private String description;

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getInstanceName() {
            return this.instanceName;
        }

        public void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        public String getAccessSets() {
            return this.accessSets;
        }

        public void setAccessSets(String accessSets) {
            this.accessSets = accessSets;
        }

        public String getRedisSets() {
            return this.redisSets;
        }

        public void setRedisSets(String redisSets) {
            this.redisSets = redisSets;
        }

        public String getVip() {
            return this.vip;
        }

        public void setVip(String vip) {
            this.vip = vip;
        }

        public String getVipv6() {
            return this.vipv6;
        }

        public void setVipv6(String vipv6) {
            this.vipv6 = vipv6;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public Integer getVipPort() {
            return this.vipPort;
        }

        public void setVipPort(Integer vipPort) {
            this.vipPort = vipPort;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getCapacityInfo() {
            return this.capacityInfo;
        }

        public void setCapacityInfo(String capacityInfo) {
            this.capacityInfo = capacityInfo;
        }

        public Integer getPayType() {
            return this.payType;
        }

        public void setPayType(Integer payType) {
            this.payType = payType;
        }

        public String getPayTypeName() {
            return this.payTypeName;
        }

        public void setPayTypeName(String payTypeName) {
            this.payTypeName = payTypeName;
        }

        public Integer getElasticIpBind() {
            return this.elasticIpBind;
        }

        public void setElasticIpBind(Integer elasticIpBind) {
            this.elasticIpBind = elasticIpBind;
        }

        public String getElasticIp() {
            return this.elasticIp;
        }

        public void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public String getOuterElasticIpId() {
            return this.outerElasticIpId;
        }

        public void setOuterElasticIpId(String outerElasticIpId) {
            this.outerElasticIpId = outerElasticIpId;
        }

        public String getWhitelists() {
            return this.whitelists;
        }

        public void setWhitelists(String whitelists) {
            this.whitelists = whitelists;
        }

        public String getExpiration() {
            return this.expiration;
        }

        public void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        public String getEngineVersion() {
            return this.engineVersion;
        }

        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        public String getEngineVersionName() {
            return this.engineVersionName;
        }

        public void setEngineVersionName(String engineVersionName) {
            this.engineVersionName = engineVersionName;
        }

        public String getArchType() {
            return this.archType;
        }

        public void setArchType(String archType) {
            this.archType = archType;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public String getSecurityGroup() {
            return this.securityGroup;
        }

        public void setSecurityGroup(String securityGroup) {
            this.securityGroup = securityGroup;
        }

        public String getNetName() {
            return this.netName;
        }

        public void setNetName(String netName) {
            this.netName = netName;
        }

        public String getSubnet() {
            return this.subnet;
        }

        public void setSubnet(String subnet) {
            this.subnet = subnet;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getExpTime() {
            return this.expTime;
        }

        public void setExpTime(String expTime) {
            this.expTime = expTime;
        }

        public String getArchTypeName() {
            return this.archTypeName;
        }

        public void setArchTypeName(String archTypeName) {
            this.archTypeName = archTypeName;
        }

        public String getNodeTypeName() {
            return this.nodeTypeName;
        }

        public void setNodeTypeName(String nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
        }

        public String getTplName() {
            return this.tplName;
        }

        public void setTplName(String tplName) {
            this.tplName = tplName;
        }

        public String getTplCode() {
            return this.tplCode;
        }

        public void setTplCode(String tplCode) {
            this.tplCode = tplCode;
        }

        public String getMaintenanceTime() {
            return this.maintenanceTime;
        }

        public void setMaintenanceTime(String maintenanceTime) {
            this.maintenanceTime = maintenanceTime;
        }

        public List<DescribeDedicatedClusterInstanceListReturnObjRowsAzListResponse> getAzList() {
            return this.azList;
        }

        public void setAzList(
                List<DescribeDedicatedClusterInstanceListReturnObjRowsAzListResponse> azList) {
            this.azList = azList;
        }

        public String getStatusName() {
            return this.statusName;
        }

        public void setStatusName(String statusName) {
            this.statusName = statusName;
        }

        public Boolean getProtectionStatus() {
            return this.protectionStatus;
        }

        public void setProtectionStatus(Boolean protectionStatus) {
            this.protectionStatus = protectionStatus;
        }

        public String getCopiesCount() {
            return this.copiesCount;
        }

        public void setCopiesCount(String copiesCount) {
            this.copiesCount = copiesCount;
        }

        public String getReadReplica() {
            return this.readReplica;
        }

        public void setReadReplica(String readReplica) {
            this.readReplica = readReplica;
        }

        public String getShardCount() {
            return this.shardCount;
        }

        public void setShardCount(String shardCount) {
            this.shardCount = shardCount;
        }

        public List<DescribeDedicatedClusterInstanceListReturnObjRowsLabelsResponse> getLabels() {
            return this.labels;
        }

        public void setLabels(
                List<DescribeDedicatedClusterInstanceListReturnObjRowsLabelsResponse> labels) {
            this.labels = labels;
        }

        public String getCpuArchType() {
            return this.cpuArchType;
        }

        public void setCpuArchType(String cpuArchType) {
            this.cpuArchType = cpuArchType;
        }

        public String getOuterProjectId() {
            return this.outerProjectId;
        }

        public void setOuterProjectId(String outerProjectId) {
            this.outerProjectId = outerProjectId;
        }

        public String getOuterProjectName() {
            return this.outerProjectName;
        }

        public void setOuterProjectName(String outerProjectName) {
            this.outerProjectName = outerProjectName;
        }

        public String getDataDiskType() {
            return this.dataDiskType;
        }

        public void setDataDiskType(String dataDiskType) {
            this.dataDiskType = dataDiskType;
        }

        public String getDataDiskTypeName() {
            return this.dataDiskTypeName;
        }

        public void setDataDiskTypeName(String dataDiskTypeName) {
            this.dataDiskTypeName = dataDiskTypeName;
        }

        public String getSysDiskType() {
            return this.sysDiskType;
        }

        public void setSysDiskType(String sysDiskType) {
            this.sysDiskType = sysDiskType;
        }

        public String getSysDiskTypeName() {
            return this.sysDiskTypeName;
        }

        public void setSysDiskTypeName(String sysDiskTypeName) {
            this.sysDiskTypeName = sysDiskTypeName;
        }

        public String getHostType() {
            return this.hostType;
        }

        public void setHostType(String hostType) {
            this.hostType = hostType;
        }

        public String getMirrorCategoryName() {
            return this.mirrorCategoryName;
        }

        public void setMirrorCategoryName(String mirrorCategoryName) {
            this.mirrorCategoryName = mirrorCategoryName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    public static class DescribeDedicatedClusterInstanceListReturnObjRowsAzListResponse {
        /** 可用区ID。 */
        @JsonProperty("azId")
        private String azId;

        /** 可用区名称。 */
        @JsonProperty("azName")
        private String azName;

        /** 可用区英文名称。 */
        @JsonProperty("azEngName")
        private String azEngName;

        public String getAzId() {
            return this.azId;
        }

        public void setAzId(String azId) {
            this.azId = azId;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }

        public String getAzEngName() {
            return this.azEngName;
        }

        public void setAzEngName(String azEngName) {
            this.azEngName = azEngName;
        }
    }

    public static class DescribeDedicatedClusterInstanceListReturnObjRowsLabelsResponse {
        /** 标签键。 */
        @JsonProperty("key")
        private String key;

        /** 标签键。 */
        @JsonProperty("value")
        private String value;

        /** 标签ID。 */
        @JsonProperty("labelId")
        private String labelId;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getLabelId() {
            return this.labelId;
        }

        public void setLabelId(String labelId) {
            this.labelId = labelId;
        }
    }
}
