package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询集群节点信息 */
public class Dcs2DescribeClusterMemberInfoApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeClusterMemberInfoApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "GET",
                        "/v2/instanceManageMgrServant/describeClusterMemberInfo",
                        "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeClusterMemberInfoResponse send(
            Credential credential, DescribeClusterMemberInfoRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeClusterMemberInfoResponse.class);
    }

    public static class DescribeClusterMemberInfoRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }
    }

    public static class DescribeClusterMemberInfoResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeClusterMemberInfoReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeClusterMemberInfoReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeClusterMemberInfoReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeClusterMemberInfoReturnObjResponse {
        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("total")
        private Integer total;

        /** 返回redis集群数据集，数据见rows。 */
        @JsonProperty("rows")
        private List<DescribeClusterMemberInfoReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<DescribeClusterMemberInfoReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<DescribeClusterMemberInfoReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class DescribeClusterMemberInfoReturnObjRowsResponse {
        /** Redis集群名。 */
        @JsonProperty("redisSetName")
        private String redisSetName;

        /** Redis集群节点信息。 */
        @JsonProperty("redisSetInfo")
        private String redisSetInfo;

        /** 更新时间戳。 */
        @JsonProperty("lastestTime")
        private String lastestTime;

        /**
         * 是否读写分离。
         * <li>true：开启。
         * <li>false：关闭。
         */
        @JsonProperty("isRWsep")
        private Boolean isRWsep;

        /** Redis节点集合，数据见RedisNode。 */
        @JsonProperty("nodes")
        private List<DescribeClusterMemberInfoReturnObjRowsNodesResponse> nodes;

        /** 槽位信息。 */
        @JsonProperty("slotInfo")
        private String slotInfo;

        /** Redis节点密码。 */
        @JsonProperty("requirepass")
        private String requirepass;

        /** Redis节点密文。 */
        @JsonProperty("requirepassEncrypt")
        private String requirepassEncrypt;

        /** 是否加密鉴权。 */
        @JsonProperty("isAuth")
        private Boolean isAuth;

        /** 实例类型（可选值见枚举值type表）。 */
        @JsonProperty("type")
        private Integer type;

        public String getRedisSetName() {
            return this.redisSetName;
        }

        public void setRedisSetName(String redisSetName) {
            this.redisSetName = redisSetName;
        }

        public String getRedisSetInfo() {
            return this.redisSetInfo;
        }

        public void setRedisSetInfo(String redisSetInfo) {
            this.redisSetInfo = redisSetInfo;
        }

        public String getLastestTime() {
            return this.lastestTime;
        }

        public void setLastestTime(String lastestTime) {
            this.lastestTime = lastestTime;
        }

        public Boolean getIsRWsep() {
            return this.isRWsep;
        }

        public void setIsRWsep(Boolean isRWsep) {
            this.isRWsep = isRWsep;
        }

        public List<DescribeClusterMemberInfoReturnObjRowsNodesResponse> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<DescribeClusterMemberInfoReturnObjRowsNodesResponse> nodes) {
            this.nodes = nodes;
        }

        public String getSlotInfo() {
            return this.slotInfo;
        }

        public void setSlotInfo(String slotInfo) {
            this.slotInfo = slotInfo;
        }

        public String getRequirepass() {
            return this.requirepass;
        }

        public void setRequirepass(String requirepass) {
            this.requirepass = requirepass;
        }

        public String getRequirepassEncrypt() {
            return this.requirepassEncrypt;
        }

        public void setRequirepassEncrypt(String requirepassEncrypt) {
            this.requirepassEncrypt = requirepassEncrypt;
        }

        public Boolean getIsAuth() {
            return this.isAuth;
        }

        public void setIsAuth(Boolean isAuth) {
            this.isAuth = isAuth;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }
    }

    public static class DescribeClusterMemberInfoReturnObjRowsNodesResponse {
        /** 主节点名称。 */
        @JsonProperty("masterName")
        private String masterName;

        /** 开始槽位。 */
        @JsonProperty("startSlot")
        private String startSlot;

        /** 结束槽位。 */
        @JsonProperty("endSlot")
        private String endSlot;

        /** 连接地址。 */
        @JsonProperty("connUrl")
        private String connUrl;

        /**
         * 节点状态。
         * <li>CACHE.COMM.STATUS：正常。
         * <li>CACHE.DIAT.PREP：扩容数据准备。
         * <li>CACHE.DIAT.PROCESS：执行扩容数据。
         * <li>CACHE.DIAT.DEL：删除。
         * <li>CACHE.PROB.SWIT：故障待切换。
         */
        @JsonProperty("status")
        private String status;

        /** 是否可用状态。 */
        @JsonProperty("enabled")
        private Boolean enabled;

        /** 分片名称。 */
        @JsonProperty("fragmentName")
        private String fragmentName;

        /** 从节点数组，数据见SlaveNode。 */
        @JsonProperty("slaveNodes")
        private List<DescribeClusterMemberInfoReturnObjRowsNodesSlaveNodesResponse> slaveNodes;

        /** vpc连接地址。 */
        @JsonProperty("vpcUrl")
        private String vpcUrl;

        /** 节点ID。 */
        @JsonProperty("spuInstDeployId")
        private String spuInstDeployId;

        /** 可用区ID。 */
        @JsonProperty("azId")
        private String azId;

        /** 可用区名称。 */
        @JsonProperty("azName")
        private String azName;

        /** 节点VPCIP。 */
        @JsonProperty("nodeVpcIp")
        private String nodeVpcIp;

        public String getMasterName() {
            return this.masterName;
        }

        public void setMasterName(String masterName) {
            this.masterName = masterName;
        }

        public String getStartSlot() {
            return this.startSlot;
        }

        public void setStartSlot(String startSlot) {
            this.startSlot = startSlot;
        }

        public String getEndSlot() {
            return this.endSlot;
        }

        public void setEndSlot(String endSlot) {
            this.endSlot = endSlot;
        }

        public String getConnUrl() {
            return this.connUrl;
        }

        public void setConnUrl(String connUrl) {
            this.connUrl = connUrl;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getFragmentName() {
            return this.fragmentName;
        }

        public void setFragmentName(String fragmentName) {
            this.fragmentName = fragmentName;
        }

        public List<DescribeClusterMemberInfoReturnObjRowsNodesSlaveNodesResponse> getSlaveNodes() {
            return this.slaveNodes;
        }

        public void setSlaveNodes(
                List<DescribeClusterMemberInfoReturnObjRowsNodesSlaveNodesResponse> slaveNodes) {
            this.slaveNodes = slaveNodes;
        }

        public String getVpcUrl() {
            return this.vpcUrl;
        }

        public void setVpcUrl(String vpcUrl) {
            this.vpcUrl = vpcUrl;
        }

        public String getSpuInstDeployId() {
            return this.spuInstDeployId;
        }

        public void setSpuInstDeployId(String spuInstDeployId) {
            this.spuInstDeployId = spuInstDeployId;
        }

        public String getAzId() {
            return this.azId;
        }

        public void setAzId(String azId) {
            this.azId = azId;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }

        public String getNodeVpcIp() {
            return this.nodeVpcIp;
        }

        public void setNodeVpcIp(String nodeVpcIp) {
            this.nodeVpcIp = nodeVpcIp;
        }
    }

    public static class DescribeClusterMemberInfoReturnObjRowsNodesSlaveNodesResponse {
        /** Redis从节点名称。 */
        @JsonProperty("slaveName")
        private String slaveName;

        /** 连接地址。 */
        @JsonProperty("connUrl")
        private String connUrl;

        /**
         * 节点状态。
         * <li>CACHE.COMM.STATUS：正常。
         * <li>CACHE.DIAT.PREP：扩容数据准备。
         * <li>CACHE.DIAT.PROCESS：执行扩容数据。
         * <li>CACHE.DIAT.DEL：删除。
         * <li>CACHE.PROB.SWIT：故障待切换。
         */
        @JsonProperty("status")
        private String status;

        /** 是否可用状态。 */
        @JsonProperty("enabled")
        private Boolean enabled;

        /** 从节点vpc连接地址。 */
        @JsonProperty("vpcUrl")
        private String vpcUrl;

        /** 节点ID。 */
        @JsonProperty("spuInstDeployId")
        private String spuInstDeployId;

        /** 可用区ID。 */
        @JsonProperty("azId")
        private String azId;

        /** 可用区名称。 */
        @JsonProperty("azName")
        private String azName;

        /** 节点VpcIp。 */
        @JsonProperty("nodeVpcIp")
        private String nodeVpcIp;

        public String getSlaveName() {
            return this.slaveName;
        }

        public void setSlaveName(String slaveName) {
            this.slaveName = slaveName;
        }

        public String getConnUrl() {
            return this.connUrl;
        }

        public void setConnUrl(String connUrl) {
            this.connUrl = connUrl;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getVpcUrl() {
            return this.vpcUrl;
        }

        public void setVpcUrl(String vpcUrl) {
            this.vpcUrl = vpcUrl;
        }

        public String getSpuInstDeployId() {
            return this.spuInstDeployId;
        }

        public void setSpuInstDeployId(String spuInstDeployId) {
            this.spuInstDeployId = spuInstDeployId;
        }

        public String getAzId() {
            return this.azId;
        }

        public void setAzId(String azId) {
            this.azId = azId;
        }

        public String getAzName() {
            return this.azName;
        }

        public void setAzName(String azName) {
            this.azName = azName;
        }

        public String getNodeVpcIp() {
            return this.nodeVpcIp;
        }

        public void setNodeVpcIp(String nodeVpcIp) {
            this.nodeVpcIp = nodeVpcIp;
        }
    }
}
