package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询备份文件信息 */
public class Dcs2DescribeBackupsApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeBackupsApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v2/redisMgr/describeBackups", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeBackupsResponse send(Credential credential, DescribeBackupsRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        if (request.prodInstId != null) {
            ctReq.addParam("prodInstId", request.prodInstId);
            request.prodInstId = null;
        }
        if (request.restoreName != null) {
            ctReq.addParam("restoreName", request.restoreName);
            request.restoreName = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeBackupsResponse.class);
    }

    public static class DescribeBackupsRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 备份恢复记录。 */
        @JsonProperty("restoreName")
        private String restoreName;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getRestoreName() {
            return this.restoreName;
        }

        public void setRestoreName(String restoreName) {
            this.restoreName = restoreName;
        }
    }

    public static class DescribeBackupsResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DescribeBackupsReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeBackupsReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeBackupsReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeBackupsReturnObjResponse {
        /** 数量。 */
        @JsonProperty("total")
        private Integer total;

        /** 备份文件信息集合，见Restore。 */
        @JsonProperty("rows")
        private List<DescribeBackupsReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<DescribeBackupsReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<DescribeBackupsReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class DescribeBackupsReturnObjRowsResponse {
        /** 备份名。 */
        @JsonProperty("restoreName")
        private String restoreName;

        /** 创建时间（格式：yyyy-MM-dd HH:mm:ss）。 */
        @JsonProperty("createTime")
        private String createTime;

        /**
         * 备份状态。
         * <li>success：成功。
         * <li>processing：进行中。
         * <li>fail：失败。
         */
        @JsonProperty("status")
        private String status;

        /**
         * 备份恢复状态。
         * <li>success：成功。
         * <li>processing：进行中。
         * <li>fail：失败。
         * <li>create：备份点创建。
         */
        @JsonProperty("recoveryStatus")
        private String recoveryStatus;

        /**
         * 备份类型。
         * <li>0：手动备份。
         * <li>1：自动备份。
         */
        @JsonProperty("type")
        private Integer type;

        /** 备注信息。 */
        @JsonProperty("remark")
        private String remark;

        public String getRestoreName() {
            return this.restoreName;
        }

        public void setRestoreName(String restoreName) {
            this.restoreName = restoreName;
        }

        public String getCreateTime() {
            return this.createTime;
        }

        public void setCreateTime(String createTime) {
            this.createTime = createTime;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getRecoveryStatus() {
            return this.recoveryStatus;
        }

        public void setRecoveryStatus(String recoveryStatus) {
            this.recoveryStatus = recoveryStatus;
        }

        public Integer getType() {
            return this.type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }
    }
}
