package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/**
 * 在创建分布式缓存Redis实例时，需要配置订购的实例类型属性version、edition、hostType、dataDiskType、capacity、shardMemSize、shardCount、copiesCount，可通过该接口查询。
 */
public class Dcs2DescribeAvailableResourceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeAvailableResourceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "GET", "/v2/lifeCycleServant/describeAvailableResource", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeAvailableResourceResponse send(
            Credential credential, DescribeAvailableResourceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeAvailableResourceResponse.class);
    }

    public static class DescribeAvailableResourceRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }
    }

    public static class DescribeAvailableResourceResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private DescribeAvailableResourceReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DescribeAvailableResourceReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DescribeAvailableResourceReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeAvailableResourceReturnObjResponse {
        /** 产品系列信息。 */
        @JsonProperty("seriesInfoList")
        private List<DescribeAvailableResourceReturnObjSeriesInfoListResponse> seriesInfoList;

        /** 系统镜像信息。 */
        @JsonProperty("mirrorArray")
        private List<DescribeAvailableResourceReturnObjMirrorArrayResponse> mirrorArray;

        public List<DescribeAvailableResourceReturnObjSeriesInfoListResponse> getSeriesInfoList() {
            return this.seriesInfoList;
        }

        public void setSeriesInfoList(
                List<DescribeAvailableResourceReturnObjSeriesInfoListResponse> seriesInfoList) {
            this.seriesInfoList = seriesInfoList;
        }

        public List<DescribeAvailableResourceReturnObjMirrorArrayResponse> getMirrorArray() {
            return this.mirrorArray;
        }

        public void setMirrorArray(
                List<DescribeAvailableResourceReturnObjMirrorArrayResponse> mirrorArray) {
            this.mirrorArray = mirrorArray;
        }
    }

    public static class DescribeAvailableResourceReturnObjSeriesInfoListResponse {
        /**
         * 版本类型。
         * <li>BASIC：基础版。
         * <li>PLUS：增强版。
         * <li>Classic：经典版(白名单)。
         */
        @JsonProperty("version")
        private String version;

        /** 产品系列编码。 */
        @JsonProperty("seriesCode")
        private String seriesCode;

        /** 产品系列名称。 */
        @JsonProperty("seriesName")
        private String seriesName;

        /** 产品系列ID。 */
        @JsonProperty("seriesId")
        private Long seriesId;

        /** 资源类型信息。 */
        @JsonProperty("resItems")
        private List<DescribeAvailableResourceReturnObjSeriesInfoListResItemsResponse> resItems;

        /** 引擎版本。 */
        @JsonProperty("engineTypeItems")
        private List<String> engineTypeItems;

        /**
         * 内存容量可选值(GB)。<br>
         * 说明：version为Classic有值。
         */
        @JsonProperty("memSizeItems")
        private List<String> memSizeItems;

        /**
         * 单分片内存可选值(GB)。<br>
         * 说明：version为BASIC和PLUS有值。
         */
        @JsonProperty("shardMemSizeItems")
        private List<String> shardMemSizeItems;

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getSeriesCode() {
            return this.seriesCode;
        }

        public void setSeriesCode(String seriesCode) {
            this.seriesCode = seriesCode;
        }

        public String getSeriesName() {
            return this.seriesName;
        }

        public void setSeriesName(String seriesName) {
            this.seriesName = seriesName;
        }

        public Long getSeriesId() {
            return this.seriesId;
        }

        public void setSeriesId(Long seriesId) {
            this.seriesId = seriesId;
        }

        public List<DescribeAvailableResourceReturnObjSeriesInfoListResItemsResponse>
                getResItems() {
            return this.resItems;
        }

        public void setResItems(
                List<DescribeAvailableResourceReturnObjSeriesInfoListResItemsResponse> resItems) {
            this.resItems = resItems;
        }

        public List<String> getEngineTypeItems() {
            return this.engineTypeItems;
        }

        public void setEngineTypeItems(List<String> engineTypeItems) {
            this.engineTypeItems = engineTypeItems;
        }

        public List<String> getMemSizeItems() {
            return this.memSizeItems;
        }

        public void setMemSizeItems(List<String> memSizeItems) {
            this.memSizeItems = memSizeItems;
        }

        public List<String> getShardMemSizeItems() {
            return this.shardMemSizeItems;
        }

        public void setShardMemSizeItems(List<String> shardMemSizeItems) {
            this.shardMemSizeItems = shardMemSizeItems;
        }
    }

    public static class DescribeAvailableResourceReturnObjMirrorArrayResponse {
        /** 操作系统。 */
        @JsonProperty("attrVal")
        private String attrVal;

        /** 排序。 */
        @JsonProperty("sort")
        private Integer sort;

        /** 操作系统名称。 */
        @JsonProperty("attrName")
        private String attrName;

        /** 状态,1：正常，其他表示异常。 */
        @JsonProperty("status")
        private Integer status;

        public String getAttrVal() {
            return this.attrVal;
        }

        public void setAttrVal(String attrVal) {
            this.attrVal = attrVal;
        }

        public Integer getSort() {
            return this.sort;
        }

        public void setSort(Integer sort) {
            this.sort = sort;
        }

        public String getAttrName() {
            return this.attrName;
        }

        public void setAttrName(String attrName) {
            this.attrName = attrName;
        }

        public Integer getStatus() {
            return this.status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }
    }

    public static class DescribeAvailableResourceReturnObjSeriesInfoListResItemsResponse {
        /**
         * 资源类型。
         * <li>ecs：云服务器。
         * <li>ebs：磁盘。
         */
        @JsonProperty("resType")
        private String resType;

        /** 资源名称。 */
        @JsonProperty("resName")
        private String resName;

        /**
         * 资源类型可选值。<br>
         * 说明：以实际返回为准。<br>
         * <br>
         * 云服务器
         * <li>S：通用型。
         * <li>C：计算型。
         * <li>M：内存型。
         * <li>HS：海光通用型。
         * <li>HC：海光计算增强型。
         * <li>KS：鲲鹏通用型。
         * <li>KC：鲲鹏计算增强型。<br>
         *     <br>
         *     磁盘
         * <li>SATA：普通IO。
         * <li>SAS：高IO。
         * <li>SSD：超高IO。
         * <li>FAST-SSD：极速型SSD。
         */
        @JsonProperty("items")
        private List<String> items;

        public String getResType() {
            return this.resType;
        }

        public void setResType(String resType) {
            this.resType = resType;
        }

        public String getResName() {
            return this.resName;
        }

        public void setResName(String resName) {
            this.resName = resName;
        }

        public List<String> getItems() {
            return this.items;
        }

        public void setItems(List<String> items) {
            this.items = items;
        }
    }
}
