package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 查询分布式缓存Redis实例支持的所有资源池。 */
public class Dcs2DescribeAvailableRegionApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DescribeAvailableRegionApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(ENDPOINT_NAME, "GET", "/v2/region/getAvailableRegion", "");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DescribeAvailableRegionResponse send(
            Credential credential, DescribeAvailableRegionRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.resPoolCode != null) {
            ctReq.addParam("resPoolCode", request.resPoolCode);
            request.resPoolCode = null;
        }
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DescribeAvailableRegionResponse.class);
    }

    public static class DescribeAvailableRegionRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("resPoolCode")
        private String resPoolCode;

        public String getResPoolCode() {
            return this.resPoolCode;
        }

        public void setResPoolCode(String resPoolCode) {
            this.resPoolCode = resPoolCode;
        }
    }

    public static class DescribeAvailableRegionResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private List<DescribeAvailableRegionReturnObjResponse> returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public List<DescribeAvailableRegionReturnObjResponse> getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(List<DescribeAvailableRegionReturnObjResponse> returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DescribeAvailableRegionReturnObjResponse {
        /** 资源池ID。 */
        @JsonProperty("resPoolCode")
        private String resPoolCode;

        /** 资源池名称。 */
        @JsonProperty("resPoolName")
        private String resPoolName;

        /** 产品实体。 */
        @JsonProperty("products")
        private List<DescribeAvailableRegionReturnObjProductsResponse> products;

        public String getResPoolCode() {
            return this.resPoolCode;
        }

        public void setResPoolCode(String resPoolCode) {
            this.resPoolCode = resPoolCode;
        }

        public String getResPoolName() {
            return this.resPoolName;
        }

        public void setResPoolName(String resPoolName) {
            this.resPoolName = resPoolName;
        }

        public List<DescribeAvailableRegionReturnObjProductsResponse> getProducts() {
            return this.products;
        }

        public void setProducts(List<DescribeAvailableRegionReturnObjProductsResponse> products) {
            this.products = products;
        }
    }

    public static class DescribeAvailableRegionReturnObjProductsResponse {
        /** 产品名称。 */
        @JsonProperty("prodName")
        private String prodName;

        /** 产品编码。 */
        @JsonProperty("prodCode")
        private String prodCode;

        /** 产品外部编码。 */
        @JsonProperty("outerProdCode")
        private String outerProdCode;

        /**
         * 产品状态。
         * <li>2：正常。
         * <li>其他表示异常。
         */
        @JsonProperty("prodStatus")
        private String prodStatus;

        public String getProdName() {
            return this.prodName;
        }

        public void setProdName(String prodName) {
            this.prodName = prodName;
        }

        public String getProdCode() {
            return this.prodCode;
        }

        public void setProdCode(String prodCode) {
            this.prodCode = prodCode;
        }

        public String getOuterProdCode() {
            return this.outerProdCode;
        }

        public void setOuterProdCode(String outerProdCode) {
            this.outerProdCode = outerProdCode;
        }

        public String getProdStatus() {
            return this.prodStatus;
        }

        public void setProdStatus(String prodStatus) {
            this.prodStatus = prodStatus;
        }
    }
}
