package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 批量退订多个分布式缓存Redis实例。 */
public class Dcs2DeleteInstancesApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DeleteInstancesApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/lifeCycleServant/deleteInstances",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DeleteInstancesResponse send(Credential credential, DeleteInstancesRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DeleteInstancesResponse.class);
    }

    public static class DeleteInstancesRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID列表，多个实例ID用英文逗号分隔，最多允许10个。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstIds")
        private List<String> prodInstIds;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<String> getProdInstIds() {
            return this.prodInstIds;
        }

        public void setProdInstIds(List<String> prodInstIds) {
            this.prodInstIds = prodInstIds;
        }
    }

    public static class DeleteInstancesResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private DeleteInstancesReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public DeleteInstancesReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(DeleteInstancesReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class DeleteInstancesReturnObjResponse {
        /** 主订单错误信息。 */
        @JsonProperty("errorMessage")
        private String errorMessage;

        /** 批量订单执行结果。 */
        @JsonProperty("batchOrderPlacementResults")
        private List<DeleteInstancesReturnObjBatchOrderPlacementResultsResponse>
                batchOrderPlacementResults;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public List<DeleteInstancesReturnObjBatchOrderPlacementResultsResponse>
                getBatchOrderPlacementResults() {
            return this.batchOrderPlacementResults;
        }

        public void setBatchOrderPlacementResults(
                List<DeleteInstancesReturnObjBatchOrderPlacementResultsResponse>
                        batchOrderPlacementResults) {
            this.batchOrderPlacementResults = batchOrderPlacementResults;
        }
    }

    public static class DeleteInstancesReturnObjBatchOrderPlacementResultsResponse {
        /** 订单错误信息。 */
        @JsonProperty("errorMessage")
        private String errorMessage;

        /** 订单是否已提交。 */
        @JsonProperty("submitted")
        private Boolean submitted;

        /** 子订单执行结果列表 */
        @JsonProperty("orderPlacedEvents")
        private List<DeleteInstancesReturnObjBatchOrderPlacementResultsOrderPlacedEventsResponse>
                orderPlacedEvents;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Boolean getSubmitted() {
            return this.submitted;
        }

        public void setSubmitted(Boolean submitted) {
            this.submitted = submitted;
        }

        public List<DeleteInstancesReturnObjBatchOrderPlacementResultsOrderPlacedEventsResponse>
                getOrderPlacedEvents() {
            return this.orderPlacedEvents;
        }

        public void setOrderPlacedEvents(
                List<DeleteInstancesReturnObjBatchOrderPlacementResultsOrderPlacedEventsResponse>
                        orderPlacedEvents) {
            this.orderPlacedEvents = orderPlacedEvents;
        }
    }

    public static
    class DeleteInstancesReturnObjBatchOrderPlacementResultsOrderPlacedEventsResponse {
        /** 子订单错误信息。 */
        @JsonProperty("errorMessage")
        private String errorMessage;

        /** 子订单是否已提交。 */
        @JsonProperty("submitted")
        private Boolean submitted;

        /** 子订单ID。 */
        @JsonProperty("newOrderId")
        private String newOrderId;

        /** 子订单号。 */
        @JsonProperty("newOrderNo")
        private String newOrderNo;

        /** 子订单总价。 */
        @JsonProperty("totalPrice")
        private Double totalPrice;

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public Boolean getSubmitted() {
            return this.submitted;
        }

        public void setSubmitted(Boolean submitted) {
            this.submitted = submitted;
        }

        public String getNewOrderId() {
            return this.newOrderId;
        }

        public void setNewOrderId(String newOrderId) {
            this.newOrderId = newOrderId;
        }

        public String getNewOrderNo() {
            return this.newOrderNo;
        }

        public void setNewOrderNo(String newOrderNo) {
            this.newOrderNo = newOrderNo;
        }

        public Double getTotalPrice() {
            return this.totalPrice;
        }

        public void setTotalPrice(Double totalPrice) {
            this.totalPrice = totalPrice;
        }
    }
}
