package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 数据闪回到新实例。 */
public class Dcs2DataFlashBackToOtherInstanceApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2DataFlashBackToOtherInstanceApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/redisMgr/dataFlashBackToOtherInstance",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public DataFlashBackToOtherInstanceResponse send(
            Credential credential, DataFlashBackToOtherInstanceRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(DataFlashBackToOtherInstanceResponse.class);
    }

    public static class DataFlashBackToOtherInstanceRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 当前实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 闪回的目标时间点（yyyy-MM-dd HH:mm:ss） */
        @JsonProperty("selectTime")
        private String selectTime;

        /** 目标实例登录账号 */
        @JsonProperty("targetAccountName")
        private String targetAccountName;

        /** 目标实例登录密码 (需要有读写权限) */
        @JsonProperty("targetPassword")
        private String targetPassword;

        /** 目标实例ID（约束：与当前实例ID属于同一租户） */
        @JsonProperty("targetProdInstId")
        private String targetProdInstId;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getSelectTime() {
            return this.selectTime;
        }

        public void setSelectTime(String selectTime) {
            this.selectTime = selectTime;
        }

        public String getTargetAccountName() {
            return this.targetAccountName;
        }

        public void setTargetAccountName(String targetAccountName) {
            this.targetAccountName = targetAccountName;
        }

        public String getTargetPassword() {
            return this.targetPassword;
        }

        public void setTargetPassword(String targetPassword) {
            this.targetPassword = targetPassword;
        }

        public String getTargetProdInstId() {
            return this.targetProdInstId;
        }

        public void setTargetProdInstId(String targetProdInstId) {
            this.targetProdInstId = targetProdInstId;
        }
    }

    public static class DataFlashBackToOtherInstanceResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }
}
