package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 创建数据迁移任务。 */
public class Dcs2CreateTransferTaskApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2CreateTransferTaskApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/transfer/createTransferTask",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateTransferTaskResponse send(Credential credential, CreateTransferTaskRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateTransferTaskResponse.class);
    }

    public static class CreateTransferTaskRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 源数据库。 */
        @JsonProperty("sourceDbInfo")
        private CreateTransferTaskSourceDbInfoRequest sourceDbInfo;

        /** 目标数据库。 */
        @JsonProperty("targetDbInfo")
        private CreateTransferTaskTargetDbInfoRequest targetDbInfo;

        /**
         * 同步模式，可选值：
         * <li>1： 全量同步+增量同步。
         * <li>2：全量同步。
         */
        @JsonProperty("syncMode")
        private Integer syncMode;

        /**
         * 数据冲突时的处理办法，可选值：
         * <li>1：中断迁移。
         * <li>2：跳过目标key，继续执行。
         * <li>3：覆盖目标key，继续执行。
         */
        @JsonProperty("conflictMode")
        private Integer conflictMode;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public CreateTransferTaskSourceDbInfoRequest getSourceDbInfo() {
            return this.sourceDbInfo;
        }

        public void setSourceDbInfo(CreateTransferTaskSourceDbInfoRequest sourceDbInfo) {
            this.sourceDbInfo = sourceDbInfo;
        }

        public CreateTransferTaskTargetDbInfoRequest getTargetDbInfo() {
            return this.targetDbInfo;
        }

        public void setTargetDbInfo(CreateTransferTaskTargetDbInfoRequest targetDbInfo) {
            this.targetDbInfo = targetDbInfo;
        }

        public Integer getSyncMode() {
            return this.syncMode;
        }

        public void setSyncMode(Integer syncMode) {
            this.syncMode = syncMode;
        }

        public Integer getConflictMode() {
            return this.conflictMode;
        }

        public void setConflictMode(Integer conflictMode) {
            this.conflictMode = conflictMode;
        }
    }

    public static class CreateTransferTaskSourceDbInfoRequest {
        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("spuInstId")
        private String spuInstId;

        /** 连接地址。 */
        @JsonProperty("ipAddr")
        private String ipAddr;

        /** 是否是原生cluster集群，输入实例ID可不填，否则必填。 */
        @JsonProperty("originalCluster")
        private Boolean originalCluster;

        /** 数据库账号。 */
        @JsonProperty("accountName")
        private String accountName;

        /** 数据库密码。 */
        @JsonProperty("password")
        private String password;

        public String getSpuInstId() {
            return this.spuInstId;
        }

        public void setSpuInstId(String spuInstId) {
            this.spuInstId = spuInstId;
        }

        public String getIpAddr() {
            return this.ipAddr;
        }

        public void setIpAddr(String ipAddr) {
            this.ipAddr = ipAddr;
        }

        public Boolean getOriginalCluster() {
            return this.originalCluster;
        }

        public void setOriginalCluster(Boolean originalCluster) {
            this.originalCluster = originalCluster;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class CreateTransferTaskTargetDbInfoRequest {
        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("spuInstId")
        private String spuInstId;

        /** 连接地址。 */
        @JsonProperty("ipAddr")
        private String ipAddr;

        /** 是否是原生cluster集群，输入实例ID可不填，否则必填。 */
        @JsonProperty("originalCluster")
        private Boolean originalCluster;

        /** 数据库账号。 */
        @JsonProperty("accountName")
        private String accountName;

        /** 数据库密码。 */
        @JsonProperty("password")
        private String password;

        public String getSpuInstId() {
            return this.spuInstId;
        }

        public void setSpuInstId(String spuInstId) {
            this.spuInstId = spuInstId;
        }

        public String getIpAddr() {
            return this.ipAddr;
        }

        public void setIpAddr(String ipAddr) {
            this.ipAddr = ipAddr;
        }

        public Boolean getOriginalCluster() {
            return this.originalCluster;
        }

        public void setOriginalCluster(Boolean originalCluster) {
            this.originalCluster = originalCluster;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class CreateTransferTaskResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private CreateTransferTaskReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CreateTransferTaskReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateTransferTaskReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CreateTransferTaskReturnObjResponse {}
}
