package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 新增分组，分组命名与db一一对应。 */
public class Dcs2CreateDbGroupApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2CreateDbGroupApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/groupManageMgrServant/createDbGroup",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CreateDbGroupResponse send(Credential credential, CreateDbGroupRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CreateDbGroupResponse.class);
    }

    public static class CreateDbGroupRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /** 分组名称，返回格式为：group.{实例ID}.test */
        @JsonProperty("groupId")
        private String groupId;

        /** 数据库编号，取值范围：0-255。 */
        @JsonProperty("db")
        private String db;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getDb() {
            return this.db;
        }

        public void setDb(String db) {
            this.db = db;
        }
    }

    public static class CreateDbGroupResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private CreateDbGroupReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CreateDbGroupReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CreateDbGroupReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CreateDbGroupReturnObjResponse {
        /** 分组名称。 */
        @JsonProperty("groupName")
        private String groupName;

        /** 分组信息。 */
        @JsonProperty("groupInfo")
        private String groupInfo;

        /** 更新时间。 */
        @JsonProperty("lastestTime")
        private String lastestTime;

        /** DB编码。 */
        @JsonProperty("dborder")
        private String dborder;

        /** 集群名。 */
        @JsonProperty("redisSetName")
        private String redisSetName;

        /** 实例名称。 */
        @JsonProperty("userName")
        private String userName;

        /** 是否使用客户端缓存。 */
        @JsonProperty("useClientCache")
        private String useClientCache;

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getGroupInfo() {
            return this.groupInfo;
        }

        public void setGroupInfo(String groupInfo) {
            this.groupInfo = groupInfo;
        }

        public String getLastestTime() {
            return this.lastestTime;
        }

        public void setLastestTime(String lastestTime) {
            this.lastestTime = lastestTime;
        }

        public String getDborder() {
            return this.dborder;
        }

        public void setDborder(String dborder) {
            this.dborder = dborder;
        }

        public String getRedisSetName() {
            return this.redisSetName;
        }

        public void setRedisSetName(String redisSetName) {
            this.redisSetName = redisSetName;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getUseClientCache() {
            return this.useClientCache;
        }

        public void setUseClientCache(String useClientCache) {
            this.useClientCache = useClientCache;
        }
    }
}
