package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 缓存类型变更的前置检查。 */
public class Dcs2CheckInstanceProdModifyApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2CheckInstanceProdModifyApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/check/checkInstanceProdModify",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public CheckInstanceProdModifyResponse send(
            Credential credential, CheckInstanceProdModifyRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(CheckInstanceProdModifyResponse.class);
    }

    public static class CheckInstanceProdModifyRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 目标实例的版本类型，取值：
         * <li>BASIC：基础版。
         * <li>PLUS：增强版。
         * <li>Classic：经典版(白名单)。
         */
        @JsonProperty("version")
        private String version;

        /**
         * 目标实例的实例类型，详细信息请参见 <a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。
         */
        @JsonProperty("edition")
        private String edition;

        /**
         * 目标实例的分片规格（单位：G），非经典版必填，详细信息请参见 <a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。<br>
         * 当 version 取值为 BASIC，取值：
         * <li>1
         * <li>2
         * <li>4
         * <li>8
         * <li>16
         * <li>32
         * <li>64<br>
         *     当 version 取值为 PLUS时，取值：
         * <li>8
         * <li>16
         * <li>32
         * <li>64<br>
         *     其他版本无需填写此参数。
         */
        @JsonProperty("shardMemSize")
        private Integer shardMemSize;

        /**
         * 目标实例的分片数，Cluster或者Proxy系列必填。
         * <li>当 edition 取值为 DirectClusterSingle/DirectCluster/ClusterOriginalProxy时: 3~256。
         * <li>当 edition 取其他值时无需填写。
         */
        @JsonProperty("shardCount")
        private Integer shardCount;

        /**
         * 目标实例的总容量（单位：G），经典版版必填，详细信息请参见 <a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11030280" target="_blank">产品规格参数说明。
         */
        @JsonProperty("memSize")
        private Integer memSize;

        /**
         * 目标实例的副本数，取值范围2~10，详细信息请参见 <a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11030280">产品规格参数说明 </a>。
         * <li>当 edition 取值为 OriginalMultipleReadLvs时必填。
         * <li>当 edition 取值为 StandardDual/DirectCluster/ClusterOriginalProxy时选填。<br>
         *     当 edition 取其他值时无需填写。
         */
        @JsonProperty("copiesCount")
        private Integer copiesCount;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getEdition() {
            return this.edition;
        }

        public void setEdition(String edition) {
            this.edition = edition;
        }

        public Integer getShardMemSize() {
            return this.shardMemSize;
        }

        public void setShardMemSize(Integer shardMemSize) {
            this.shardMemSize = shardMemSize;
        }

        public Integer getShardCount() {
            return this.shardCount;
        }

        public void setShardCount(Integer shardCount) {
            this.shardCount = shardCount;
        }

        public Integer getMemSize() {
            return this.memSize;
        }

        public void setMemSize(Integer memSize) {
            this.memSize = memSize;
        }

        public Integer getCopiesCount() {
            return this.copiesCount;
        }

        public void setCopiesCount(Integer copiesCount) {
            this.copiesCount = copiesCount;
        }
    }

    public static class CheckInstanceProdModifyResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 响应对象。 */
        @JsonProperty("returnObj")
        private CheckInstanceProdModifyReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public CheckInstanceProdModifyReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(CheckInstanceProdModifyReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class CheckInstanceProdModifyReturnObjResponse {
        /** 是否支持当前操作。 */
        @JsonProperty("isSupport")
        private Boolean isSupport;

        /** 不支持的原因。 */
        @JsonProperty("notSupportReason")
        private String notSupportReason;

        public Boolean getIsSupport() {
            return this.isSupport;
        }

        public void setIsSupport(Boolean isSupport) {
            this.isSupport = isSupport;
        }

        public String getNotSupportReason() {
            return this.notSupportReason;
        }

        public void setNotSupportReason(String notSupportReason) {
            this.notSupportReason = notSupportReason;
        }
    }
}
