package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 自动续费开关，可设置实例到期后自动续费周期，该操作为幂等操作，重复执行返回相同结果。 */
public class Dcs2ChangeAutoRenewStatusApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2ChangeAutoRenewStatusApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/res/spuInst/changeAutoRenewStatus",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public ChangeAutoRenewStatusResponse send(
            Credential credential, ChangeAutoRenewStatusRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(ChangeAutoRenewStatusResponse.class);
    }

    public static class ChangeAutoRenewStatusRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 待改变自动续订状态的实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。列表。
         */
        @JsonProperty("prodInstIds")
        private List<String> prodInstIds;

        /**
         * 自动续订状态。
         * <li>1：自动续订。
         * <li>0：不自动续订。
         */
        @JsonProperty("autoRenewStatus")
        private Integer autoRenewStatus;

        /**
         * 自动续订周期类型。<br>
         * autoRenewStatus=1时必填，可选：
         * <li>3：月。
         * <li>5：年。
         */
        @JsonProperty("autoRenewCycleType")
        private String autoRenewCycleType;

        /**
         * 自动续费周期(月)。<br>
         * autoRenewStatus=1时必填，可选：1~6,12,24,36。
         */
        @JsonProperty("autoRenewCycleCount")
        private Integer autoRenewCycleCount;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<String> getProdInstIds() {
            return this.prodInstIds;
        }

        public void setProdInstIds(List<String> prodInstIds) {
            this.prodInstIds = prodInstIds;
        }

        public Integer getAutoRenewStatus() {
            return this.autoRenewStatus;
        }

        public void setAutoRenewStatus(Integer autoRenewStatus) {
            this.autoRenewStatus = autoRenewStatus;
        }

        public String getAutoRenewCycleType() {
            return this.autoRenewCycleType;
        }

        public void setAutoRenewCycleType(String autoRenewCycleType) {
            this.autoRenewCycleType = autoRenewCycleType;
        }

        public Integer getAutoRenewCycleCount() {
            return this.autoRenewCycleCount;
        }

        public void setAutoRenewCycleCount(Integer autoRenewCycleCount) {
            this.autoRenewCycleCount = autoRenewCycleCount;
        }
    }

    public static class ChangeAutoRenewStatusResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private ChangeAutoRenewStatusReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public ChangeAutoRenewStatusReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(ChangeAutoRenewStatusReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ChangeAutoRenewStatusReturnObjResponse {
        /**
         * 响应状态码。
         * <li>800：自动续订下单成功。
         * <li>900：自动续订下单失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }
    }
}
