package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

/** 批量创建标签。 */
public class Dcs2BatchAddLabelApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2BatchAddLabelApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME, "POST", "/v2/label/batchAdd", "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public BatchAddLabelResponse send(Credential credential, BatchAddLabelRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(BatchAddLabelResponse.class);
    }

    public static class BatchAddLabelRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /** 标签列表对象。 */
        @JsonProperty("labelKVList")
        private List<BatchAddLabelLabelKVListRequest> labelKVList;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public List<BatchAddLabelLabelKVListRequest> getLabelKVList() {
            return this.labelKVList;
        }

        public void setLabelKVList(List<BatchAddLabelLabelKVListRequest> labelKVList) {
            this.labelKVList = labelKVList;
        }
    }

    public static class BatchAddLabelLabelKVListRequest {
        /**
         * 标签键。<br>
         * 说明：长度限制1-32个字符。
         */
        @JsonProperty("key")
        private String key;

        /**
         * 标签值。<br>
         * 说明：长度限制1-32个字符。
         */
        @JsonProperty("value")
        private String value;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class BatchAddLabelResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 返回数据对象，数据见returnObj。 */
        @JsonProperty("returnObj")
        private BatchAddLabelReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public BatchAddLabelReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(BatchAddLabelReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class BatchAddLabelReturnObjResponse {
        /** 数量。 */
        @JsonProperty("total")
        private Integer total;

        /** 标签键值对。 */
        @JsonProperty("rows")
        private List<BatchAddLabelReturnObjRowsResponse> rows;

        public Integer getTotal() {
            return this.total;
        }

        public void setTotal(Integer total) {
            this.total = total;
        }

        public List<BatchAddLabelReturnObjRowsResponse> getRows() {
            return this.rows;
        }

        public void setRows(List<BatchAddLabelReturnObjRowsResponse> rows) {
            this.rows = rows;
        }
    }

    public static class BatchAddLabelReturnObjRowsResponse {
        /** 标签键，小于32个字节。 */
        @JsonProperty("key")
        private String key;

        /** 标签值，小于32个字节。 */
        @JsonProperty("value")
        private String value;

        /** 标签ID。 */
        @JsonProperty("labelId")
        private String labelId;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getLabelId() {
            return this.labelId;
        }

        public void setLabelId(String labelId) {
            this.labelId = labelId;
        }
    }
}
