package cn.ctyun.apis;

import static cn.ctyun.apis.Apis.ENDPOINT_NAME;

import cn.ctyun.sdk.*;

import com.fasterxml.jackson.annotation.JsonProperty;

/** 分布式缓存Redis实例过期key扫描配置，配置自动扫描过期key的时间，间隔，数量等信息。 */
public class Dcs2AutoScanExpiredKeysApi {
    private final CtyunRequestTemplate template;
    private final CtyunClient client;

    public Dcs2AutoScanExpiredKeysApi(CtyunClient client) {
        this.client = client;
        this.template =
                new CtyunRequestTemplate(
                        ENDPOINT_NAME,
                        "POST",
                        "/v2/redisMgr/autoScanExpiredKeys",
                        "application/json");
    }

    /**
     * 发起请求
     *
     * @param credential 用户信息
     * @param request 请求
     * @return 响应
     * @throws CtyunRequestException 异常
     */
    public AutoScanExpiredKeysResponse send(
            Credential credential, AutoScanExpiredKeysRequest request)
            throws CtyunRequestException {
        CtyunRequestBuilder builder = new CtyunRequestBuilder(template);
        builder.withCredential(credential);
        CtyunRequest ctReq = builder.build();
        if (request.regionId != null) {
            ctReq.addHeader("regionId", request.regionId);
            request.regionId = null;
        }
        ctReq.writeJson(request, template.contentType);
        CtyunResponse response = this.client.requestToEndpoint(ctReq);
        return response.parse(AutoScanExpiredKeysResponse.class);
    }

    public static class AutoScanExpiredKeysRequest {
        /**
         * 资源池ID。获取方法如下：<br>
         * 方法一：通过查看附录文档<a target="_blank" rel="noopener noreferrer"
         * href="https://www.ctyun.cn/document/10029420/11067697">分布式缓存服务Redis资源池</a>获取资源池ID。<br>
         * 方法二：可调用 <a target="_blank" rel="noopener noreferrer"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7830&isNormal=1&vid=270">查询可用的资源池</a>
         * 接口获取resPoolCode字段。
         */
        @JsonProperty("regionId")
        private String regionId;

        /**
         * 实例ID。获取方法如下：<br>
         * 方法一：可登录分布式缓存控制台在实例列表复制实例ID。<br>
         * 方法二：可调用<a target="_blank"
         * href="https://eop.ctyun.cn/ebp/ctapiDocument/search?sid=49&api=7728&isNormal=1&vid=270">
         * 查询实例列表 </a>接口获取prodInstId字段。
         */
        @JsonProperty("prodInstId")
        private String prodInstId;

        /**
         * 是否启用自动扫描过期key功能，可选值：
         * <li>true：启用。
         * <li>false：禁用。
         */
        @JsonProperty("enableAutoScan")
        private Boolean enableAutoScan;

        /** 首次扫描时间，格式：yyyy-MM-dd HH:mm:ss，例如：2023-07-07 15:00:05。当enableAutoScan设置为true时，该参数为必选。 */
        @JsonProperty("firstScanAt")
        private String firstScanAt;

        /** 扫描间隔（分），输入值必须在5到43,200之间。。当enableAutoScan设置为true时，该参数为必选。 */
        @JsonProperty("interval")
        private Integer interval;

        /** 迭代扫描key数量，输入值必须在10到1000之间。当enableAutoScan设置为true时，该参数为必选。 */
        @JsonProperty("scanKeysCount")
        private Integer scanKeysCount;

        /** 扫描超时（分），输入值必须在1到86,400之间。当enableAutoScan设置为true时，该参数为必选。 */
        @JsonProperty("timeout")
        private Integer timeout;

        public String getRegionId() {
            return this.regionId;
        }

        public void setRegionId(String regionId) {
            this.regionId = regionId;
        }

        public String getProdInstId() {
            return this.prodInstId;
        }

        public void setProdInstId(String prodInstId) {
            this.prodInstId = prodInstId;
        }

        public Boolean getEnableAutoScan() {
            return this.enableAutoScan;
        }

        public void setEnableAutoScan(Boolean enableAutoScan) {
            this.enableAutoScan = enableAutoScan;
        }

        public String getFirstScanAt() {
            return this.firstScanAt;
        }

        public void setFirstScanAt(String firstScanAt) {
            this.firstScanAt = firstScanAt;
        }

        public Integer getInterval() {
            return this.interval;
        }

        public void setInterval(Integer interval) {
            this.interval = interval;
        }

        public Integer getScanKeysCount() {
            return this.scanKeysCount;
        }

        public void setScanKeysCount(Integer scanKeysCount) {
            this.scanKeysCount = scanKeysCount;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }
    }

    public static class AutoScanExpiredKeysResponse {
        /**
         * 响应状态码。
         * <li>800：成功。
         * <li>900：失败。
         */
        @JsonProperty("statusCode")
        private Integer statusCode;

        /** 响应信息。 */
        @JsonProperty("message")
        private String message;

        /** 无返回数据，空对象。 */
        @JsonProperty("returnObj")
        private AutoScanExpiredKeysReturnObjResponse returnObj;

        /** 请求 ID。 */
        @JsonProperty("requestId")
        private String requestId;

        /** 响应码，仅表示请求是否执行。 */
        @JsonProperty("code")
        private String code;

        /** 错误码，参见错误码说明。 */
        @JsonProperty("error")
        private String error;

        public Integer getStatusCode() {
            return this.statusCode;
        }

        public void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public AutoScanExpiredKeysReturnObjResponse getReturnObj() {
            return this.returnObj;
        }

        public void setReturnObj(AutoScanExpiredKeysReturnObjResponse returnObj) {
            this.returnObj = returnObj;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class AutoScanExpiredKeysReturnObjResponse {}
}
